/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import pl.decerto.hyperon.common.persistence.jpa.BaseEntity;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;

@Entity
public class SystemRightJPA
extends BaseEntity {
    public static final int MAX_DESCRIPTION_LENGTH = 255;
    @Id
    @SequenceGenerator(name="systemrightjpa_id_generator", sequenceName="SEQ_SYSTEM_RIGHT_JPA")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="systemrightjpa_id_generator")
    private int id;
    @Column(nullable=false, unique=true)
    @NotEmpty
    private String code;
    @Column
    private String description;
    @NotNull
    private Date createDate;
    @ManyToMany(mappedBy="rights", fetch=FetchType.EAGER)
    private Set<SystemRoleJPA> roles = new HashSet<SystemRoleJPA>();

    @PrePersist
    public void create() {
        this.createDate = new Date();
    }

    public void setCode(String code) {
        this.code = code.toUpperCase();
    }

    public void addRole(SystemRoleJPA roleJPA) {
        this.roles.add(roleJPA);
    }

    public String toString() {
        return "SystemRightJPA [ id=" + this.id + ", code=" + this.code + ", description=" + this.description + ", createDate=" + this.createDate + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemRightJPA roleJPA = (SystemRightJPA)o;
        return this.id == roleJPA.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Set<SystemRoleJPA> getRoles() {
        return this.roles;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setRoles(Set<SystemRoleJPA> roles) {
        this.roles = roles;
    }
}

