/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.sqldialect;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.PostgresPlusDialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.LongVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class PostgreSQLDialect
extends PostgresPlusDialect {
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2005, (JdbcType)LongVarcharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2004, (JdbcType)VarbinaryJdbcType.INSTANCE);
    }

    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -7, 16 -> "smallint";
            case -6 -> "integer";
            case 5 -> "integer";
            case 2005 -> "text";
            case 2004 -> "bytea";
            default -> super.columnType(sqlTypeCode);
        };
    }
}

