/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.dto.SystemUserPreference;

public final class LoginHelper {
    private LoginHelper() {
        throw new UnsupportedOperationException();
    }

    public static String getCurrentUserName() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return null;
        }
        Object principal = auth.getPrincipal();
        if (principal instanceof String) {
            return null;
        }
        if (principal instanceof MppUserDetails) {
            return ((MppUserDetails)principal).getUsername();
        }
        throw new UnsupportedOperationException("not implemented principal:" + principal + ", can't retrieve user name");
    }

    public static String getCurrentProfileCode() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            return null;
        }
        Object principal = auth.getPrincipal();
        if (principal instanceof String) {
            return null;
        }
        if (principal instanceof MppUserDetails) {
            return LoginHelper.getProfilePreference((MppUserDetails)principal);
        }
        throw new UnsupportedOperationException("not implemented principal:" + principal + ", can't retrieve profile code");
    }

    private static String getProfilePreference(MppUserDetails userDetails) {
        return userDetails.getPreference("DOMAIN_PROFILE").map(SystemUserPreference::getValue).orElse(null);
    }
}

