/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.configuration;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import pl.decerto.hyperon.common.utils.configuration.ConfigurationItem;
import pl.decerto.hyperon.common.utils.configuration.MultipleConfigurationItem;
import pl.decerto.hyperon.common.utils.configuration.SingleConfigurationItem;

public interface ConfigurationContainer<E> {
    @NotNull
    public <T extends MultipleConfigurationItem<E>> List<T> getMultipleConfigurationItems(@NotNull Class<T> var1);

    @NotNull
    public List<ConfigurationItem<E>> getConfigurationItems();

    @NotNull
    public <T extends SingleConfigurationItem<E>> Optional<T> getConfigurationItem(@NotNull Class<T> var1);

    public void addApplicableConfigurationItems(@NotNull Iterable<? extends ConfigurationItem<E>> var1, @NotNull E var2);

    public void addConfigurationItem(@NotNull ConfigurationItem<E> var1);

    public void addMultipleConfigurationItem(@NotNull MultipleConfigurationItem<E> var1);

    public void addSingleConfigurationItem(@NotNull SingleConfigurationItem<E> var1);

    public void removeSingleConfigurationItemOfType(Class<? extends SingleConfigurationItem<E>> var1);

    default public <T extends ConfigurationContainer<E>> T withSingleConfigurationItem(@NotNull SingleConfigurationItem<E> item) {
        this.addSingleConfigurationItem(item);
        ConfigurationContainer result = this;
        return (T)result;
    }

    default public <T extends ConfigurationContainer<E>> T withMultipleConfigurationItem(@NotNull MultipleConfigurationItem<E> item) {
        this.addMultipleConfigurationItem(item);
        ConfigurationContainer result = this;
        return (T)result;
    }
}

