/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.cache.user;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.cache.UserCacheWatcher;
import pl.decerto.hyperon.common.security.dao.UserJdbcDao;
import pl.decerto.hyperon.rest.cache.user.SystemUserCache;

@Component
@ConditionalOnProperty(name={"higson.runtime-rest.security.user-cache-enabled"}, havingValue="true")
public class SystemUserCacheWatcher
extends UserCacheWatcher {
    private static final Logger log = LoggerFactory.getLogger(SystemUserCacheWatcher.class);
    private final SystemUserCache systemUserCache;

    @Autowired
    public SystemUserCacheWatcher(UserJdbcDao cacheDao, SystemUserCache systemUserCache) {
        super(cacheDao, null);
        this.systemUserCache = systemUserCache;
    }

    protected void invalidate() {
        log.trace("Invalidating cache...");
        this.systemUserCache.clear();
    }
}

