/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.core.HigsonEngineFactory;
import io.higson.runtime.core.WatchersConfig;
import io.higson.runtime.core.domain.DomainCache;
import io.higson.runtime.sync.DomainWatcherConfig;
import io.higson.runtime.sync.WatcherConfig;
import java.time.temporal.TemporalUnit;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import pl.decerto.hyperon.common.external.ExternalDataSourceProvider;
import pl.decerto.hyperon.rest.configuration.HyperonEngineProperties;

@Configuration
@EnableConfigurationProperties(value={HyperonEngineProperties.class})
public class HyperonEngineConfiguration {
    private final ExternalDataSourceProvider externalDataSourceProvider;

    @Bean(destroyMethod="destroy")
    public HigsonEngineFactory higsonEngineFactory(@Qualifier(value="dataSource") DataSource dataSource, HyperonEngineProperties properties) {
        this.externalDataSourceProvider.configure(dataSource);
        HigsonEngineFactory factory = new HigsonEngineFactory(dataSource);
        factory.setDeveloperMode(properties.getRuntime().isDevModeEnabled());
        factory.setUsername(properties.getRuntime().getUsername());
        factory.setMaxConcurrentLoads(properties.getRuntime().getMaxConcurrentLoads());
        HyperonEngineConfiguration.setWatchers(factory.getWatchersConfig(), properties.getRuntime().getWatcher());
        factory.setValidateFunctionArgumentsDataTypes(properties.getRuntime().getFunction().isValidateArguments());
        factory.setThrowOnNormalizeInputValueException(properties.getRuntime().getNormalization().isThrowOnException());
        factory.setGroovySecured(properties.getRuntime().getGroovy().isSecured());
        factory.addExternalDataSources(this.externalDataSourceProvider.getDataSources());
        return factory;
    }

    @Bean
    public HigsonEngine higsonEngine(HigsonEngineFactory engineFactory) {
        return engineFactory.create();
    }

    @Bean
    @DependsOn(value={"higsonEngine"})
    public DomainCache domainCache(HigsonEngineFactory engineFactory) {
        return engineFactory.getDomainCache();
    }

    private static void setWatchers(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        HyperonEngineConfiguration.configureParamWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureFunctionWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureVersionWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureProfileWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureUserRegionVersionWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureDomainWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureDevModeWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureScheduleWatcher(watchersConfig, watcherProperties);
        HyperonEngineConfiguration.configureRefreshWatcher(watchersConfig, watcherProperties);
    }

    private static void configureRefreshWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig refreshWatcherConfig = watchersConfig.getRefreshWatcherConfig();
        HyperonEngineProperties.WatcherConfig properties = watcherProperties.getRefreshWatcherConfig();
        refreshWatcherConfig.pause(properties.getPause());
        refreshWatcherConfig.delay(properties.getStartDelay());
        refreshWatcherConfig.error(properties.getErrorPause());
    }

    private static void configureScheduleWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig scheduleRuntimeWatcherConfig = watchersConfig.getScheduleRuntimeWatcherConfig();
        HyperonEngineProperties.WatcherConfig properties = watcherProperties.getScheduleRuntimeWatcherConfig();
        scheduleRuntimeWatcherConfig.pause(properties.getPause());
        scheduleRuntimeWatcherConfig.delay(properties.getStartDelay());
        scheduleRuntimeWatcherConfig.error(properties.getErrorPause());
    }

    private static void configureDevModeWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig devModeWatcherConfig = watchersConfig.getDevModeWatcherConfig();
        HyperonEngineProperties.WatcherConfig properties = watcherProperties.getDevModeWatcherConfig();
        devModeWatcherConfig.pause(properties.getPause());
        devModeWatcherConfig.delay(properties.getStartDelay());
        devModeWatcherConfig.error(properties.getErrorPause());
    }

    private static void configureDomainWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        DomainWatcherConfig domainWatcherConfig = watchersConfig.getDomainWatcherConfig();
        HyperonEngineProperties.DomainWatcherConfig properties = watcherProperties.getDomainWatcherConfig();
        domainWatcherConfig.pause(properties.getPause());
        domainWatcherConfig.delay(properties.getStartDelay());
        domainWatcherConfig.error(properties.getErrorPause());
        domainWatcherConfig.invalidate(properties.getInvalidate(), (TemporalUnit)properties.getTimeUnit());
    }

    private static void configureUserRegionVersionWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig userRegionVersionWatcherConfig = watchersConfig.getUserRegionVersionWatcherConfig();
        HyperonEngineProperties.WatcherConfig properties = watcherProperties.getUserRegionVersionWatcherConfig();
        userRegionVersionWatcherConfig.pause(properties.getPause());
        userRegionVersionWatcherConfig.delay(properties.getStartDelay());
        userRegionVersionWatcherConfig.error(properties.getErrorPause());
    }

    private static void configureProfileWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig profileWatcherConfig = watchersConfig.getProfileWatcherConfig();
        HyperonEngineProperties.WatcherConfig properties = watcherProperties.getProfileWatcherConfig();
        profileWatcherConfig.pause(properties.getPause());
        profileWatcherConfig.delay(properties.getStartDelay());
        profileWatcherConfig.error(properties.getErrorPause());
    }

    private static void configureVersionWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig versionWatcherConfig = watchersConfig.getVersionWatcherConfig();
        HyperonEngineProperties.WatcherConfig properties = watcherProperties.getVersionWatcherConfig();
        versionWatcherConfig.pause(properties.getPause());
        versionWatcherConfig.delay(properties.getStartDelay());
        versionWatcherConfig.error(properties.getErrorPause());
    }

    private static void configureFunctionWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig functionWatcherConfig = watchersConfig.getFunctionWatcherConfig();
        HyperonEngineProperties.WatcherConfig properties = watcherProperties.getFunctionWatcherConfig();
        functionWatcherConfig.pause(properties.getPause());
        functionWatcherConfig.delay(properties.getStartDelay());
        functionWatcherConfig.error(properties.getErrorPause());
    }

    private static void configureParamWatcher(WatchersConfig watchersConfig, HyperonEngineProperties.Watcher watcherProperties) {
        WatcherConfig paramWatcherConfig = watchersConfig.getParamWatcherConfig();
        HyperonEngineProperties.ParamWatcherConfig properties = watcherProperties.getParamWatcherConfig();
        paramWatcherConfig.pause(properties.getPause());
        paramWatcherConfig.delay(properties.getStartDelay());
        paramWatcherConfig.error(properties.getErrorPause());
        paramWatcherConfig.force(properties.getForce());
    }

    public HyperonEngineConfiguration(ExternalDataSourceProvider externalDataSourceProvider) {
        this.externalDataSourceProvider = externalDataSourceProvider;
    }
}

