/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import io.higson.runtime.core.WatchersConfig;
import java.time.temporal.ChronoUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="higson")
public class HyperonEngineProperties
implements InitializingBean {
    private Runtime runtime = new Runtime();

    private static void validate(boolean devMode, String devUserName) {
        if (devMode && devUserName == null) {
            throw new IllegalArgumentException("The higson.runtime.username property is required when running with higson.runtime.dev-mode-enabled=true");
        }
    }

    public void afterPropertiesSet() {
        HyperonEngineProperties.validate(this.runtime.devModeEnabled, this.runtime.username);
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperonEngineProperties)) {
            return false;
        }
        HyperonEngineProperties other = (HyperonEngineProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Runtime this$runtime = this.getRuntime();
        Runtime other$runtime = other.getRuntime();
        return !(this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperonEngineProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Runtime $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        return result;
    }

    public String toString() {
        return "HyperonEngineProperties(runtime=" + this.getRuntime() + ")";
    }

    public static class Runtime {
        private boolean enabled;
        private boolean devModeEnabled = false;
        private String username = null;
        private int maxConcurrentLoads = 3;
        private Watcher watcher = new Watcher();
        private Function function = new Function();
        private Normalization normalization = new Normalization();
        private Groovy groovy = new Groovy();

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDevModeEnabled() {
            return this.devModeEnabled;
        }

        public String getUsername() {
            return this.username;
        }

        public int getMaxConcurrentLoads() {
            return this.maxConcurrentLoads;
        }

        public Watcher getWatcher() {
            return this.watcher;
        }

        public Function getFunction() {
            return this.function;
        }

        public Normalization getNormalization() {
            return this.normalization;
        }

        public Groovy getGroovy() {
            return this.groovy;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDevModeEnabled(boolean devModeEnabled) {
            this.devModeEnabled = devModeEnabled;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setMaxConcurrentLoads(int maxConcurrentLoads) {
            this.maxConcurrentLoads = maxConcurrentLoads;
        }

        public void setWatcher(Watcher watcher) {
            this.watcher = watcher;
        }

        public void setFunction(Function function) {
            this.function = function;
        }

        public void setNormalization(Normalization normalization) {
            this.normalization = normalization;
        }

        public void setGroovy(Groovy groovy) {
            this.groovy = groovy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Runtime)) {
                return false;
            }
            Runtime other = (Runtime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.isDevModeEnabled() != other.isDevModeEnabled()) {
                return false;
            }
            if (this.getMaxConcurrentLoads() != other.getMaxConcurrentLoads()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            Watcher this$watcher = this.getWatcher();
            Watcher other$watcher = other.getWatcher();
            if (this$watcher == null ? other$watcher != null : !((Object)this$watcher).equals(other$watcher)) {
                return false;
            }
            Function this$function = this.getFunction();
            Function other$function = other.getFunction();
            if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
                return false;
            }
            Normalization this$normalization = this.getNormalization();
            Normalization other$normalization = other.getNormalization();
            if (this$normalization == null ? other$normalization != null : !((Object)this$normalization).equals(other$normalization)) {
                return false;
            }
            Groovy this$groovy = this.getGroovy();
            Groovy other$groovy = other.getGroovy();
            return !(this$groovy == null ? other$groovy != null : !((Object)this$groovy).equals(other$groovy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Runtime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isDevModeEnabled() ? 79 : 97);
            result = result * 59 + this.getMaxConcurrentLoads();
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            Watcher $watcher = this.getWatcher();
            result = result * 59 + ($watcher == null ? 43 : ((Object)$watcher).hashCode());
            Function $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
            Normalization $normalization = this.getNormalization();
            result = result * 59 + ($normalization == null ? 43 : ((Object)$normalization).hashCode());
            Groovy $groovy = this.getGroovy();
            result = result * 59 + ($groovy == null ? 43 : ((Object)$groovy).hashCode());
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Runtime(enabled=" + this.isEnabled() + ", devModeEnabled=" + this.isDevModeEnabled() + ", username=" + this.getUsername() + ", maxConcurrentLoads=" + this.getMaxConcurrentLoads() + ", watcher=" + this.getWatcher() + ", function=" + this.getFunction() + ", normalization=" + this.getNormalization() + ", groovy=" + this.getGroovy() + ")";
        }
    }

    public static class DomainWatcherConfig
    extends WatcherConfig {
        private int invalidate;
        private ChronoUnit timeUnit;

        public DomainWatcherConfig(int startDelay, int pause, int errorPause, int invalidate, ChronoUnit timeUnit) {
            super(startDelay, pause, errorPause);
            this.invalidate = invalidate;
            this.timeUnit = timeUnit;
        }

        public static DomainWatcherConfigBuilder domainWatcherConfigBuilder() {
            return new DomainWatcherConfigBuilder();
        }

        public int getInvalidate() {
            return this.invalidate;
        }

        public ChronoUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setInvalidate(int invalidate) {
            this.invalidate = invalidate;
        }

        public void setTimeUnit(ChronoUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public String toString() {
            return "HyperonEngineProperties.DomainWatcherConfig(invalidate=" + this.getInvalidate() + ", timeUnit=" + this.getTimeUnit() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DomainWatcherConfig)) {
                return false;
            }
            DomainWatcherConfig other = (DomainWatcherConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getInvalidate() != other.getInvalidate()) {
                return false;
            }
            ChronoUnit this$timeUnit = this.getTimeUnit();
            ChronoUnit other$timeUnit = other.getTimeUnit();
            return !(this$timeUnit == null ? other$timeUnit != null : !this$timeUnit.equals(other$timeUnit));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof DomainWatcherConfig;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getInvalidate();
            ChronoUnit $timeUnit = this.getTimeUnit();
            result = result * 59 + ($timeUnit == null ? 43 : $timeUnit.hashCode());
            return result;
        }

        public static class DomainWatcherConfigBuilder {
            private int startDelay;
            private int pause;
            private int errorPause;
            private int invalidate;
            private ChronoUnit timeUnit;

            DomainWatcherConfigBuilder() {
            }

            public DomainWatcherConfigBuilder startDelay(int startDelay) {
                this.startDelay = startDelay;
                return this;
            }

            public DomainWatcherConfigBuilder pause(int pause) {
                this.pause = pause;
                return this;
            }

            public DomainWatcherConfigBuilder errorPause(int errorPause) {
                this.errorPause = errorPause;
                return this;
            }

            public DomainWatcherConfigBuilder invalidate(int invalidate) {
                this.invalidate = invalidate;
                return this;
            }

            public DomainWatcherConfigBuilder timeUnit(ChronoUnit timeUnit) {
                this.timeUnit = timeUnit;
                return this;
            }

            public DomainWatcherConfig build() {
                return new DomainWatcherConfig(this.startDelay, this.pause, this.errorPause, this.invalidate, this.timeUnit);
            }

            public String toString() {
                return "HyperonEngineProperties.DomainWatcherConfig.DomainWatcherConfigBuilder(startDelay=" + this.startDelay + ", pause=" + this.pause + ", errorPause=" + this.errorPause + ", invalidate=" + this.invalidate + ", timeUnit=" + this.timeUnit + ")";
            }
        }
    }

    public static class ParamWatcherConfig
    extends WatcherConfig {
        private int force;

        public ParamWatcherConfig(int startDelay, int pause, int errorPause, int force) {
            super(startDelay, pause, errorPause);
            this.force = force;
        }

        public static ParamWatcherConfigBuilder paramWatcherConfigBuilder() {
            return new ParamWatcherConfigBuilder();
        }

        public int getForce() {
            return this.force;
        }

        public void setForce(int force) {
            this.force = force;
        }

        @Override
        public String toString() {
            return "HyperonEngineProperties.ParamWatcherConfig(force=" + this.getForce() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamWatcherConfig)) {
                return false;
            }
            ParamWatcherConfig other = (ParamWatcherConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.getForce() == other.getForce();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ParamWatcherConfig;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getForce();
            return result;
        }

        public static class ParamWatcherConfigBuilder {
            private int startDelay;
            private int pause;
            private int errorPause;
            private int force;

            ParamWatcherConfigBuilder() {
            }

            public ParamWatcherConfigBuilder startDelay(int startDelay) {
                this.startDelay = startDelay;
                return this;
            }

            public ParamWatcherConfigBuilder pause(int pause) {
                this.pause = pause;
                return this;
            }

            public ParamWatcherConfigBuilder errorPause(int errorPause) {
                this.errorPause = errorPause;
                return this;
            }

            public ParamWatcherConfigBuilder force(int force) {
                this.force = force;
                return this;
            }

            public ParamWatcherConfig build() {
                return new ParamWatcherConfig(this.startDelay, this.pause, this.errorPause, this.force);
            }

            public String toString() {
                return "HyperonEngineProperties.ParamWatcherConfig.ParamWatcherConfigBuilder(startDelay=" + this.startDelay + ", pause=" + this.pause + ", errorPause=" + this.errorPause + ", force=" + this.force + ")";
            }
        }
    }

    public static class WatcherConfig {
        private int startDelay;
        private int pause;
        private int errorPause;

        public static WatcherConfigBuilder builder() {
            return new WatcherConfigBuilder();
        }

        public int getStartDelay() {
            return this.startDelay;
        }

        public int getPause() {
            return this.pause;
        }

        public int getErrorPause() {
            return this.errorPause;
        }

        public void setStartDelay(int startDelay) {
            this.startDelay = startDelay;
        }

        public void setPause(int pause) {
            this.pause = pause;
        }

        public void setErrorPause(int errorPause) {
            this.errorPause = errorPause;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WatcherConfig)) {
                return false;
            }
            WatcherConfig other = (WatcherConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartDelay() != other.getStartDelay()) {
                return false;
            }
            if (this.getPause() != other.getPause()) {
                return false;
            }
            return this.getErrorPause() == other.getErrorPause();
        }

        protected boolean canEqual(Object other) {
            return other instanceof WatcherConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartDelay();
            result = result * 59 + this.getPause();
            result = result * 59 + this.getErrorPause();
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.WatcherConfig(startDelay=" + this.getStartDelay() + ", pause=" + this.getPause() + ", errorPause=" + this.getErrorPause() + ")";
        }

        public WatcherConfig(int startDelay, int pause, int errorPause) {
            this.startDelay = startDelay;
            this.pause = pause;
            this.errorPause = errorPause;
        }

        public WatcherConfig() {
        }

        public static class WatcherConfigBuilder {
            private int startDelay;
            private int pause;
            private int errorPause;

            WatcherConfigBuilder() {
            }

            public WatcherConfigBuilder startDelay(int startDelay) {
                this.startDelay = startDelay;
                return this;
            }

            public WatcherConfigBuilder pause(int pause) {
                this.pause = pause;
                return this;
            }

            public WatcherConfigBuilder errorPause(int errorPause) {
                this.errorPause = errorPause;
                return this;
            }

            public WatcherConfig build() {
                return new WatcherConfig(this.startDelay, this.pause, this.errorPause);
            }

            public String toString() {
                return "HyperonEngineProperties.WatcherConfig.WatcherConfigBuilder(startDelay=" + this.startDelay + ", pause=" + this.pause + ", errorPause=" + this.errorPause + ")";
            }
        }
    }

    public static class Watcher {
        private ParamWatcherConfig paramWatcherConfig = new ParamWatcherConfig.ParamWatcherConfigBuilder().startDelay(10).pause(3).errorPause(30).force(60).build();
        private WatcherConfig functionWatcherConfig = new WatcherConfig.WatcherConfigBuilder().startDelay(10).pause(3).errorPause(30).build();
        private WatcherConfig versionWatcherConfig = new WatcherConfig.WatcherConfigBuilder().startDelay(10).pause(3).errorPause(30).build();
        private WatcherConfig profileWatcherConfig = new WatcherConfig.WatcherConfigBuilder().startDelay(10).pause(3).errorPause(30).build();
        private WatcherConfig userRegionVersionWatcherConfig = new WatcherConfig.WatcherConfigBuilder().startDelay(10).pause(3).errorPause(30).build();
        private DomainWatcherConfig domainWatcherConfig = new DomainWatcherConfig.DomainWatcherConfigBuilder().startDelay(10).pause(3).errorPause(30).invalidate(24).timeUnit(WatchersConfig.DOMAIN_WATCHER_INVALIDATE_TIME_UNIT).build();
        private WatcherConfig devModeWatcherConfig = new WatcherConfig.WatcherConfigBuilder().startDelay(10).pause(1).errorPause(30).build();
        private WatcherConfig scheduleRuntimeWatcherConfig = new WatcherConfig.WatcherConfigBuilder().startDelay(10).pause(10).errorPause(30).build();
        private WatcherConfig refreshWatcherConfig = new WatcherConfig.WatcherConfigBuilder().startDelay(15).pause(10).errorPause(30).build();

        public ParamWatcherConfig getParamWatcherConfig() {
            return this.paramWatcherConfig;
        }

        public WatcherConfig getFunctionWatcherConfig() {
            return this.functionWatcherConfig;
        }

        public WatcherConfig getVersionWatcherConfig() {
            return this.versionWatcherConfig;
        }

        public WatcherConfig getProfileWatcherConfig() {
            return this.profileWatcherConfig;
        }

        public WatcherConfig getUserRegionVersionWatcherConfig() {
            return this.userRegionVersionWatcherConfig;
        }

        public DomainWatcherConfig getDomainWatcherConfig() {
            return this.domainWatcherConfig;
        }

        public WatcherConfig getDevModeWatcherConfig() {
            return this.devModeWatcherConfig;
        }

        public WatcherConfig getScheduleRuntimeWatcherConfig() {
            return this.scheduleRuntimeWatcherConfig;
        }

        public WatcherConfig getRefreshWatcherConfig() {
            return this.refreshWatcherConfig;
        }

        public void setParamWatcherConfig(ParamWatcherConfig paramWatcherConfig) {
            this.paramWatcherConfig = paramWatcherConfig;
        }

        public void setFunctionWatcherConfig(WatcherConfig functionWatcherConfig) {
            this.functionWatcherConfig = functionWatcherConfig;
        }

        public void setVersionWatcherConfig(WatcherConfig versionWatcherConfig) {
            this.versionWatcherConfig = versionWatcherConfig;
        }

        public void setProfileWatcherConfig(WatcherConfig profileWatcherConfig) {
            this.profileWatcherConfig = profileWatcherConfig;
        }

        public void setUserRegionVersionWatcherConfig(WatcherConfig userRegionVersionWatcherConfig) {
            this.userRegionVersionWatcherConfig = userRegionVersionWatcherConfig;
        }

        public void setDomainWatcherConfig(DomainWatcherConfig domainWatcherConfig) {
            this.domainWatcherConfig = domainWatcherConfig;
        }

        public void setDevModeWatcherConfig(WatcherConfig devModeWatcherConfig) {
            this.devModeWatcherConfig = devModeWatcherConfig;
        }

        public void setScheduleRuntimeWatcherConfig(WatcherConfig scheduleRuntimeWatcherConfig) {
            this.scheduleRuntimeWatcherConfig = scheduleRuntimeWatcherConfig;
        }

        public void setRefreshWatcherConfig(WatcherConfig refreshWatcherConfig) {
            this.refreshWatcherConfig = refreshWatcherConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Watcher)) {
                return false;
            }
            Watcher other = (Watcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ParamWatcherConfig this$paramWatcherConfig = this.getParamWatcherConfig();
            ParamWatcherConfig other$paramWatcherConfig = other.getParamWatcherConfig();
            if (this$paramWatcherConfig == null ? other$paramWatcherConfig != null : !((Object)this$paramWatcherConfig).equals(other$paramWatcherConfig)) {
                return false;
            }
            WatcherConfig this$functionWatcherConfig = this.getFunctionWatcherConfig();
            WatcherConfig other$functionWatcherConfig = other.getFunctionWatcherConfig();
            if (this$functionWatcherConfig == null ? other$functionWatcherConfig != null : !((Object)this$functionWatcherConfig).equals(other$functionWatcherConfig)) {
                return false;
            }
            WatcherConfig this$versionWatcherConfig = this.getVersionWatcherConfig();
            WatcherConfig other$versionWatcherConfig = other.getVersionWatcherConfig();
            if (this$versionWatcherConfig == null ? other$versionWatcherConfig != null : !((Object)this$versionWatcherConfig).equals(other$versionWatcherConfig)) {
                return false;
            }
            WatcherConfig this$profileWatcherConfig = this.getProfileWatcherConfig();
            WatcherConfig other$profileWatcherConfig = other.getProfileWatcherConfig();
            if (this$profileWatcherConfig == null ? other$profileWatcherConfig != null : !((Object)this$profileWatcherConfig).equals(other$profileWatcherConfig)) {
                return false;
            }
            WatcherConfig this$userRegionVersionWatcherConfig = this.getUserRegionVersionWatcherConfig();
            WatcherConfig other$userRegionVersionWatcherConfig = other.getUserRegionVersionWatcherConfig();
            if (this$userRegionVersionWatcherConfig == null ? other$userRegionVersionWatcherConfig != null : !((Object)this$userRegionVersionWatcherConfig).equals(other$userRegionVersionWatcherConfig)) {
                return false;
            }
            DomainWatcherConfig this$domainWatcherConfig = this.getDomainWatcherConfig();
            DomainWatcherConfig other$domainWatcherConfig = other.getDomainWatcherConfig();
            if (this$domainWatcherConfig == null ? other$domainWatcherConfig != null : !((Object)this$domainWatcherConfig).equals(other$domainWatcherConfig)) {
                return false;
            }
            WatcherConfig this$devModeWatcherConfig = this.getDevModeWatcherConfig();
            WatcherConfig other$devModeWatcherConfig = other.getDevModeWatcherConfig();
            if (this$devModeWatcherConfig == null ? other$devModeWatcherConfig != null : !((Object)this$devModeWatcherConfig).equals(other$devModeWatcherConfig)) {
                return false;
            }
            WatcherConfig this$scheduleRuntimeWatcherConfig = this.getScheduleRuntimeWatcherConfig();
            WatcherConfig other$scheduleRuntimeWatcherConfig = other.getScheduleRuntimeWatcherConfig();
            if (this$scheduleRuntimeWatcherConfig == null ? other$scheduleRuntimeWatcherConfig != null : !((Object)this$scheduleRuntimeWatcherConfig).equals(other$scheduleRuntimeWatcherConfig)) {
                return false;
            }
            WatcherConfig this$refreshWatcherConfig = this.getRefreshWatcherConfig();
            WatcherConfig other$refreshWatcherConfig = other.getRefreshWatcherConfig();
            return !(this$refreshWatcherConfig == null ? other$refreshWatcherConfig != null : !((Object)this$refreshWatcherConfig).equals(other$refreshWatcherConfig));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Watcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ParamWatcherConfig $paramWatcherConfig = this.getParamWatcherConfig();
            result = result * 59 + ($paramWatcherConfig == null ? 43 : ((Object)$paramWatcherConfig).hashCode());
            WatcherConfig $functionWatcherConfig = this.getFunctionWatcherConfig();
            result = result * 59 + ($functionWatcherConfig == null ? 43 : ((Object)$functionWatcherConfig).hashCode());
            WatcherConfig $versionWatcherConfig = this.getVersionWatcherConfig();
            result = result * 59 + ($versionWatcherConfig == null ? 43 : ((Object)$versionWatcherConfig).hashCode());
            WatcherConfig $profileWatcherConfig = this.getProfileWatcherConfig();
            result = result * 59 + ($profileWatcherConfig == null ? 43 : ((Object)$profileWatcherConfig).hashCode());
            WatcherConfig $userRegionVersionWatcherConfig = this.getUserRegionVersionWatcherConfig();
            result = result * 59 + ($userRegionVersionWatcherConfig == null ? 43 : ((Object)$userRegionVersionWatcherConfig).hashCode());
            DomainWatcherConfig $domainWatcherConfig = this.getDomainWatcherConfig();
            result = result * 59 + ($domainWatcherConfig == null ? 43 : ((Object)$domainWatcherConfig).hashCode());
            WatcherConfig $devModeWatcherConfig = this.getDevModeWatcherConfig();
            result = result * 59 + ($devModeWatcherConfig == null ? 43 : ((Object)$devModeWatcherConfig).hashCode());
            WatcherConfig $scheduleRuntimeWatcherConfig = this.getScheduleRuntimeWatcherConfig();
            result = result * 59 + ($scheduleRuntimeWatcherConfig == null ? 43 : ((Object)$scheduleRuntimeWatcherConfig).hashCode());
            WatcherConfig $refreshWatcherConfig = this.getRefreshWatcherConfig();
            result = result * 59 + ($refreshWatcherConfig == null ? 43 : ((Object)$refreshWatcherConfig).hashCode());
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Watcher(paramWatcherConfig=" + this.getParamWatcherConfig() + ", functionWatcherConfig=" + this.getFunctionWatcherConfig() + ", versionWatcherConfig=" + this.getVersionWatcherConfig() + ", profileWatcherConfig=" + this.getProfileWatcherConfig() + ", userRegionVersionWatcherConfig=" + this.getUserRegionVersionWatcherConfig() + ", domainWatcherConfig=" + this.getDomainWatcherConfig() + ", devModeWatcherConfig=" + this.getDevModeWatcherConfig() + ", scheduleRuntimeWatcherConfig=" + this.getScheduleRuntimeWatcherConfig() + ", refreshWatcherConfig=" + this.getRefreshWatcherConfig() + ")";
        }
    }

    public static class Groovy {
        private boolean secured = true;

        public boolean isSecured() {
            return this.secured;
        }

        public void setSecured(boolean secured) {
            this.secured = secured;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Groovy)) {
                return false;
            }
            Groovy other = (Groovy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isSecured() == other.isSecured();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Groovy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSecured() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Groovy(secured=" + this.isSecured() + ")";
        }
    }

    public static class Normalization {
        private boolean throwOnException = false;

        public boolean isThrowOnException() {
            return this.throwOnException;
        }

        public void setThrowOnException(boolean throwOnException) {
            this.throwOnException = throwOnException;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Normalization)) {
                return false;
            }
            Normalization other = (Normalization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isThrowOnException() == other.isThrowOnException();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Normalization;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isThrowOnException() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Normalization(throwOnException=" + this.isThrowOnException() + ")";
        }
    }

    public static class Function {
        private boolean validateArguments = false;

        public boolean isValidateArguments() {
            return this.validateArguments;
        }

        public void setValidateArguments(boolean validateArguments) {
            this.validateArguments = validateArguments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Function)) {
                return false;
            }
            Function other = (Function)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isValidateArguments() == other.isValidateArguments();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Function;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValidateArguments() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Function(validateArguments=" + this.isValidateArguments() + ")";
        }
    }
}

