/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.logger;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.common.logger.ConfigurationLoggerSection;
import pl.decerto.hyperon.rest.configuration.HyperonEngineProperties;

class HigsonEngineConfigurationLoggerSection
implements ConfigurationLoggerSection {
    private final HyperonEngineProperties engineProperties;

    public String getName() {
        return "Higson engine";
    }

    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(Map.of("Developer mode", this.engineProperties.getRuntime().isDevModeEnabled(), "Max concurrent loads", this.engineProperties.getRuntime().getMaxConcurrentLoads(), "Param watcher pause seconds", this.engineProperties.getRuntime().getWatcher().getParamWatcherConfig().getPause(), "Function watcher pause seconds", this.engineProperties.getRuntime().getWatcher().getFunctionWatcherConfig().getPause(), "Validate function arguments data types", this.engineProperties.getRuntime().getFunction().isValidateArguments(), "Throw exception on normalize input value exception", this.engineProperties.getRuntime().getNormalization().isThrowOnException(), "Groovy secured", this.engineProperties.getRuntime().getGroovy().isSecured()));
        if (this.engineProperties.getRuntime().isDevModeEnabled()) {
            properties.put("Developer user name", StringUtils.defaultString((String)this.engineProperties.getRuntime().getUsername()));
        }
        return properties;
    }

    public HigsonEngineConfigurationLoggerSection(HyperonEngineProperties engineProperties) {
        this.engineProperties = engineProperties;
    }
}

