/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenNotValidException;

final class JwtTokenUtils {
    private static final String JWT_TOKEN_BEARER = "Bearer ";
    public static final String PAYLOAD_USER_LOGIN = "userLogin";
    public static final String PAYLOAD_FIRST_NAME = "firstName";
    public static final String PAYLOAD_LAST_NAME = "lastName";
    public static final String PAYLOAD_EMAIL = "email";

    public static String getTokenWithoutBearer(String bearerToken) {
        if (!bearerToken.startsWith(JWT_TOKEN_BEARER)) {
            throw new JwtTokenNotValidException("Wrong type of token");
        }
        return bearerToken.substring(7);
    }

    public static String getClaimOrThrow(String name, Jws<Claims> claimsJws) {
        return Optional.ofNullable((String)((Claims)claimsJws.getBody()).get(name, String.class)).filter(StringUtils::isNotBlank).orElseThrow(() -> new JwtTokenNotValidException("Cannot parse required values from JWT token"));
    }

    private JwtTokenUtils() {
    }
}

