/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.bool.BooleanHolder;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.string.StringHolder;
import java.util.Collection;
import java.util.Objects;

public class TrimUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "trim";
    public static final UtilFunction INSTANCE = new TrimUtilFunction();

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object object = ctx.get(path);
        return this.trim(object);
    }

    private Object trim(Object targetObject) {
        return IdentifyValueUtil.identify(targetObject).map(targetObjectHolder -> this.trimHolderValue(targetObject, (ValueHolder)targetObjectHolder)).orElse(null);
    }

    private Object trimHolderValue(Object targetObject, ValueHolder targetObjectHolder) {
        if (targetObject instanceof Collection) {
            Collection collection = (Collection)targetObject;
            return collection.stream().filter(Objects::nonNull).toList();
        }
        if (targetObjectHolder instanceof NumberHolder) {
            NumberHolder targetHolder = (NumberHolder)targetObjectHolder;
            return targetHolder.getBigDecimal();
        }
        if (targetObjectHolder instanceof IntegerHolder) {
            IntegerHolder targetHolder = (IntegerHolder)targetObjectHolder;
            return targetHolder.getBigDecimal();
        }
        if (targetObjectHolder instanceof BooleanHolder) {
            BooleanHolder targetHolder = (BooleanHolder)targetObjectHolder;
            return targetHolder.getValue();
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            LocalDateHolder targetHolder = (LocalDateHolder)targetObjectHolder;
            return targetHolder.getValue();
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            LocalDateTimeHolder targetHolder = (LocalDateTimeHolder)targetObjectHolder;
            return targetHolder.getValue();
        }
        if (targetObjectHolder instanceof StringHolder) {
            StringHolder targetHolder = (StringHolder)targetObjectHolder;
            return targetHolder.getValue().trim();
        }
        throw this.createHigsonRuntimeException(CODE, "Cannot trim '" + targetObject + " type is not supported!");
    }

    private TrimUtilFunction() {
    }
}

