/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.cache;

import io.higson.runtime.cache.ProfileCache;
import io.higson.runtime.cache.ProfileProviderHelper;
import io.higson.runtime.core.datasource.VersionDao;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileProvider {
    private static final Logger log = LoggerFactory.getLogger(ProfileProvider.class);
    private final ProfileCache profileCache;
    private final VersionDao versionJdbcDao;

    public Optional<String> get(@NotNull String regionCode, String version) {
        String profile;
        String cachedProfile = this.profileCache.get(regionCode, version);
        if (StringUtils.isNotBlank((CharSequence)cachedProfile)) {
            return Optional.of(cachedProfile);
        }
        log.debug("Cache miss for regionCode: {} and version {}", (Object)regionCode, (Object)version);
        String string = profile = version == null ? this.getProfile(regionCode) : this.getProfile(regionCode, version);
        if (StringUtils.isNotBlank((CharSequence)profile)) {
            this.profileCache.put(regionCode, version, profile);
            return Optional.of(profile);
        }
        log.debug("Profile for regionCode: {} and version {} does not exist in db", (Object)regionCode, (Object)version);
        return Optional.empty();
    }

    private String getProfile(String regionCode) {
        List<String> profiles = this.versionJdbcDao.getProfiles(regionCode);
        return ProfileProviderHelper.getProfile(profiles, regionCode, null);
    }

    private String getProfile(String regionCode, String version) {
        List<String> profiles = this.versionJdbcDao.getProfiles(regionCode, version);
        return ProfileProviderHelper.getProfile(profiles, regionCode, version);
    }

    public ProfileProvider(ProfileCache profileCache, VersionDao versionJdbcDao) {
        this.profileCache = profileCache;
        this.versionJdbcDao = versionJdbcDao;
    }
}

