/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core;

import ai.onnxruntime.OrtEnvironment;
import io.higson.runtime.cache.ProfileCache;
import io.higson.runtime.cache.ProfileProvider;
import io.higson.runtime.cache.UserRegionVersionCache;
import io.higson.runtime.cache.UserRegionVersionProvider;
import io.higson.runtime.constants.FunctionCode;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.core.HigsonEngineImpl;
import io.higson.runtime.core.Properties;
import io.higson.runtime.core.StdFunctionInterceptor;
import io.higson.runtime.core.WatchersConfig;
import io.higson.runtime.core.datasource.HigsonDataSource;
import io.higson.runtime.core.datasource.database.HigsonDbDataSource;
import io.higson.runtime.core.datasource.snapshot.HigsonSnapshotDataSource;
import io.higson.runtime.core.domain.AttributeInterceptor;
import io.higson.runtime.core.domain.AttributeValueProvider;
import io.higson.runtime.core.domain.AttributeValueResolver;
import io.higson.runtime.core.domain.DomainCache;
import io.higson.runtime.core.domain.DomainCacheManager;
import io.higson.runtime.core.domain.MpDomainCache;
import io.higson.runtime.core.domain.MpDomainCacheManager;
import io.higson.runtime.core.domain.MpDomainCacheProvider;
import io.higson.runtime.core.domain.MpDomainRefreshController;
import io.higson.runtime.core.domain.MpUserSessionProvider;
import io.higson.runtime.core.domain.WatcherDomainCacheManager;
import io.higson.runtime.core.extdatasource.ExternalDataSourceProvider;
import io.higson.runtime.core.factory.EffectiveVersionFactory;
import io.higson.runtime.core.factory.SystemVersionFactory;
import io.higson.runtime.core.versioninterceptor.DeveloperModeInterceptor;
import io.higson.runtime.core.versioninterceptor.EffectiveVersionResolver;
import io.higson.runtime.core.versioninterceptor.RuntimeVersionInterceptor;
import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.dao.DevModeJdbcDao;
import io.higson.runtime.dao.external.ExternalStorageDao;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.decoder.MpDecodingStrategy;
import io.higson.runtime.dev.DevModePerspective;
import io.higson.runtime.dev.DevModeProvider;
import io.higson.runtime.dev.DevModeUserProvider;
import io.higson.runtime.engine.cache.MapFunctionCache;
import io.higson.runtime.engine.cache.MapPreparedParamCache;
import io.higson.runtime.engine.config.ParamEngineConfig;
import io.higson.runtime.engine.config.ParamEngineConfigBuilder;
import io.higson.runtime.engine.config.ParamEngineFactory;
import io.higson.runtime.engine.core.ParamEngine;
import io.higson.runtime.engine.core.SmartParamEngine;
import io.higson.runtime.engine.core.function.FunctionCache;
import io.higson.runtime.engine.core.prepared.PreparedParamCache;
import io.higson.runtime.engine.ext.FunctionInvokerInterceptor;
import io.higson.runtime.engine.matchers.BetweenMatcher;
import io.higson.runtime.engine.matchers.BetweenMatcherTokenSeparator;
import io.higson.runtime.engine.types.date.DateType;
import io.higson.runtime.engine.types.date.LocalDateType;
import io.higson.runtime.engine.types.datetime.DatetimeType;
import io.higson.runtime.engine.types.datetime.LocalDateTimeType;
import io.higson.runtime.engine.types.number.NumberType;
import io.higson.runtime.engine.types.string.StringType;
import io.higson.runtime.engine.util.Printer;
import io.higson.runtime.evict.DefaultIdleChecker;
import io.higson.runtime.evict.IdleChecker;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.function.FunctionInvocationInterceptor;
import io.higson.runtime.function.argument.FunctionArgumentDataTypeValidator;
import io.higson.runtime.function.log.FunctionLogLevelCache;
import io.higson.runtime.function.log.FunctionLoggerCreator;
import io.higson.runtime.function.log.LogListener;
import io.higson.runtime.helper.parser.CachingDateParser;
import io.higson.runtime.helper.parser.CachingNumberParser;
import io.higson.runtime.helper.parser.CachingSplitter;
import io.higson.runtime.invoker.FlowInvoker;
import io.higson.runtime.invoker.GroovyFunctionInvoker;
import io.higson.runtime.invoker.PropFunctionInvoker;
import io.higson.runtime.invoker.PythonFunctionInvoker;
import io.higson.runtime.invoker.RhinoFunctionInvoker;
import io.higson.runtime.level.OutputLevelArraySeparator;
import io.higson.runtime.matcher.ContainsAllMatcher;
import io.higson.runtime.matcher.ContainsAnyMatcher;
import io.higson.runtime.matcher.ContainsNoneMatcher;
import io.higson.runtime.matcher.InMatcher;
import io.higson.runtime.matcher.LikeMatcher;
import io.higson.runtime.matcher.NotInMatcher;
import io.higson.runtime.matcher.RegexMatcher;
import io.higson.runtime.prefetch.FunctionInitializerImpl;
import io.higson.runtime.prefetch.Initializer;
import io.higson.runtime.prefetch.ParamInitializerImpl;
import io.higson.runtime.prefetch.ParametersByRegionsPrefetchStrategy;
import io.higson.runtime.prefetch.PrefetchStrategyAsyncExecutor;
import io.higson.runtime.prefetch.SimplePrefetchStrategy;
import io.higson.runtime.provider.MpFunctionProvider;
import io.higson.runtime.provider.MpParameterProvider;
import io.higson.runtime.provider.MpPropFunctionProvider;
import io.higson.runtime.provider.MpScheduleProvider;
import io.higson.runtime.provider.ai.AiModelExecutor;
import io.higson.runtime.provider.ai.ParameterAiModelServiceImpl;
import io.higson.runtime.provider.external.ExtSqlExecutor;
import io.higson.runtime.reload.AsyncReloader;
import io.higson.runtime.reload.DefaultReloader;
import io.higson.runtime.reload.NoneReloadPolicy;
import io.higson.runtime.reload.NopReloader;
import io.higson.runtime.reload.ReloadPolicy;
import io.higson.runtime.reload.Reloader;
import io.higson.runtime.rhino.RhinoDate;
import io.higson.runtime.rhino.RhinoDomain;
import io.higson.runtime.rhino.RhinoHigson;
import io.higson.runtime.rhino.RhinoMath;
import io.higson.runtime.rhino.RhinoStr;
import io.higson.runtime.rhino.RhinoType;
import io.higson.runtime.rhino.RhinoUtil;
import io.higson.runtime.sync.BaseWatcher;
import io.higson.runtime.sync.DevModeWatcher;
import io.higson.runtime.sync.DomainRuntimeWatcher;
import io.higson.runtime.sync.FunctionRuntimeWatcher;
import io.higson.runtime.sync.ParamRuntimeWatcher;
import io.higson.runtime.sync.ProfileRuntimeWatcher;
import io.higson.runtime.sync.RefreshRuntimeWatcher;
import io.higson.runtime.sync.ScheduleRuntimeWatcher;
import io.higson.runtime.sync.UserRegionVersionRuntimeWatcher;
import io.higson.runtime.sync.VersionRuntimeWatcher;
import io.higson.runtime.sync.WatcherConfig;
import io.higson.runtime.sync.event.WatcherEventListener;
import io.higson.runtime.type.BooleanType;
import io.higson.runtime.type.IntegerType;
import io.higson.runtime.type.TypesDto;
import io.higson.runtime.version.system.SystemVersionCache;
import io.higson.runtime.version.system.SystemVersionProvider;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HigsonEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(HigsonEngineFactory.class);
    private static final int PROP_REPO_ORDER = 110;
    private static final int JAVA_REPO_ORDER = 120;
    private static final int DEFAULT_DATE_CACHE_SIZE = 5000;
    private static final int DEFAULT_NUMBER_CACHE_SIZE = 40000;
    private static final int DEFAULT_SPLITTER_CACHE_SIZE = 40000;
    private static final int DEFAULT_BETWEEN_MATCHER_CACHE_SIZE = 10000;
    private HigsonDataSource higsonDataSource;
    private boolean valueNeverNull = true;
    private boolean autoStartWatchers = true;
    private boolean enableDomainCache = true;
    private int maxConcurrentLoads = 3;
    private MpUserSessionProvider sessionProvider;
    private final WatchersConfig watchersConfig = new WatchersConfig();
    private ExternalStorageDao externalStorageDao;
    private MpParameterProvider parameterProvider;
    private MpFunctionProvider functionProvider;
    private MpPropFunctionProvider propFunctionProvider;
    private PropFunctionInvoker propFunctionInvoker;
    private RhinoFunctionInvoker rhinoFunctionInvoker;
    private GroovyFunctionInvoker groovyFunctionInvoker;
    private FlowInvoker flowInvoker;
    private PythonFunctionInvoker pythonFunctionInvoker;
    private MpDecodingStrategy decodingStrategy;
    private FunctionInvokerInterceptor levelCreatorInterceptor;
    private boolean groovySecured;
    private boolean supportedPython;
    private List<String> sharedModules;
    private DomainRuntimeWatcher domainRuntimeWatcher;
    private MpDomainCacheProvider domainCacheProvider;
    private DomainCacheManager domainCacheManager;
    private DomainCache domainCache;
    private ProfileCache profileCache;
    private ProfileProvider profileProvider;
    private UserRegionVersionCache userRegionVersionCache;
    private UserRegionVersionProvider userRegionVersionProvider;
    private ParamRuntimeWatcher paramRuntimeWatcher;
    private PreparedParamCache preparedParamCache;
    private FunctionRuntimeWatcher functionRuntimeWatcher;
    private FunctionCache functionCache;
    private VersionRuntimeWatcher versionRuntimeWatcher;
    private ProfileRuntimeWatcher profileRuntimeWatcher;
    private UserRegionVersionRuntimeWatcher userRegionVersionRuntimeWatcher;
    private VersionInterceptor versionInterceptor;
    private EffectiveVersionResolver effectiveVersionResolver;
    private MpScheduleProvider scheduleProvider;
    private ScheduleRuntimeWatcher scheduleRuntimeWatcher;
    private RefreshRuntimeWatcher refreshRuntimeWatcher;
    private boolean developerMode;
    private String username;
    private DevModeProvider devModeProvider;
    private DevModeWatcher devModeWatcher;
    private boolean validateFunctionArgumentsDataTypes;
    private Map<String, Object> customPlugins;
    private List<String> paramsToPrefetch;
    private List<String> functionsToPrefetch;
    private Map<String, List<String>> profileToRegionsForParametersPrefetch = new HashMap<String, List<String>>();
    private AttributeInterceptor attributeInterceptor;
    private WatcherEventListener watcherEventListener;
    private List<FunctionInvocationInterceptor> functionInvocationInterceptors = new ArrayList<FunctionInvocationInterceptor>();
    private Duration functionLogLevelCacheTTL = FunctionLogLevelCache.DEFAULT_TTL;
    private ExternalDataSourceProvider externalDataSourceProvider;
    private ExtSqlExecutor extSqlExecutor;
    private OutputLevelArraySeparator outputLevelArraySeparator = OutputLevelArraySeparator.COMMA;
    private SystemVersionCache systemVersionCache;
    private SystemVersionProvider systemVersionProvider;
    private final Properties properties = new Properties();
    private final Collection<LogListener> logListeners = new ArrayList<LogListener>();
    private Initializer paramInitializerImpl;
    private Initializer functionInitializerImpl;
    private IdleChecker idleChecker = new DefaultIdleChecker(Duration.ofHours(16L));
    private ReloadPolicy reloadPolicy;
    private Reloader reloader;
    private AsyncReloader asyncReloader;
    private int dateCacheSize = 5000;
    private int numberCacheSize = 40000;
    private int splitterCacheSize = 40000;
    private int betweenMatcherCacheSize = 10000;
    private CachingSplitter splitter;
    private BetweenMatcherTokenSeparator tokenSeparator;
    private boolean groovyIndyCompilation;

    public void setHigsonDataSource(HigsonDataSource higsonDataSource) {
        this.higsonDataSource = higsonDataSource;
        this.setDataSource(higsonDataSource);
    }

    public HigsonEngineFactory(HigsonDataSource higsonDataSource) {
        this.setDataSource(higsonDataSource);
    }

    public HigsonEngineFactory(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.setDataSource(new HigsonDbDataSource(dataSource, connectionInterceptor));
    }

    public HigsonEngineFactory(DataSource dataSource) {
        this.setDataSource(new HigsonDbDataSource(dataSource));
    }

    public final void setDataSource(DataSource dataSource) {
        if (this.higsonDataSource == null) {
            this.setDataSource(new HigsonDbDataSource(dataSource));
        } else {
            log.warn("DataSource is already set {}", (Object)this.higsonDataSource.datasourceInfo());
        }
    }

    public final void setDataSource(HigsonDataSource dataSource) {
        this.higsonDataSource = dataSource;
        this.decodingStrategy = new MpDecodingStrategy();
        this.externalDataSourceProvider = new ExternalDataSourceProvider();
        HigsonDataSource higsonDataSource = this.higsonDataSource;
        if (higsonDataSource instanceof HigsonDbDataSource) {
            HigsonDbDataSource dbDataSource = (HigsonDbDataSource)higsonDataSource;
            this.extSqlExecutor = new ExtSqlExecutor(this.externalDataSourceProvider, dbDataSource.getConnectionInterceptor());
            this.externalStorageDao = new ExternalStorageDao(dbDataSource.getDataSource(), dbDataSource.getConnectionInterceptor());
        }
        SystemVersionFactory systemVersionFactory = new SystemVersionFactory(dataSource.getVersionDao());
        this.systemVersionCache = systemVersionFactory.getSystemVersionCache();
        this.systemVersionProvider = systemVersionFactory.getSystemVersionProvider();
        dataSource.setDataSource(this.decodingStrategy, this.extSqlExecutor);
        this.scheduleProvider = new MpScheduleProvider(dataSource.getVersionDao(), dataSource.getParamDao(), dataSource.getFunctionDao());
        EffectiveVersionFactory effectiveVersionFactory = new EffectiveVersionFactory(this.systemVersionProvider, this.scheduleProvider);
        this.effectiveVersionResolver = effectiveVersionFactory.getEffectiveVersionResolver();
        this.userRegionVersionCache = new UserRegionVersionCache();
        this.userRegionVersionProvider = new UserRegionVersionProvider(this.higsonDataSource.getDomainCacheJdbcDao(), this.userRegionVersionCache);
    }

    public void setValueNeverNull(boolean valueNeverNull) {
        this.valueNeverNull = valueNeverNull;
    }

    public void setMaxConcurrentLoads(int maxConcurrentLoads) {
        this.maxConcurrentLoads = maxConcurrentLoads;
    }

    public void setSessionProvider(MpUserSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
        if (this.domainCache != null) {
            this.domainCache.setUserSessionProvider(sessionProvider);
        }
    }

    public void setAutoStartWatchers(boolean autoStartWatchers) {
        this.autoStartWatchers = autoStartWatchers;
    }

    @Deprecated
    public void setRhinoPlugins(Map<String, Object> rhinoPlugins) {
        this.customPlugins = rhinoPlugins;
    }

    public void setCustomPlugins(Map<String, Object> customPlugins) {
        this.customPlugins = customPlugins;
    }

    public void setParamsToPrefetch(List<String> paramsToPrefetch) {
        this.paramsToPrefetch = paramsToPrefetch;
    }

    public void setFunctionsToPrefetch(List<String> functionsToPrefetch) {
        this.functionsToPrefetch = functionsToPrefetch;
    }

    public void addRegionForParametersPrefetch(String profileCode, String regionCode) {
        if (StringUtils.isBlank((CharSequence)profileCode)) {
            throw new IllegalArgumentException("profileCode should not be blank");
        }
        if (StringUtils.isBlank((CharSequence)regionCode)) {
            throw new IllegalArgumentException("regionCode should not be blank");
        }
        this.profileToRegionsForParametersPrefetch.computeIfAbsent(profileCode, key -> new ArrayList()).add(regionCode);
    }

    public HigsonEngineImpl create() {
        ConnectionInterceptor connectionInterceptor;
        log.info("creating Higson Runtime component...");
        if (this.higsonDataSource == null) {
            throw new HigsonRuntimeException("Illegal HigsonEngineFactory usage: no dataSource found");
        }
        if (this.externalDataSourceProvider.hasExternalDataSources()) {
            this.printExternalDataSources();
        }
        FunctionLogLevelCache logLevelCache = new FunctionLogLevelCache(this.functionLogLevelCacheTTL);
        FunctionLoggerCreator functionLoggerCreator = new FunctionLoggerCreator(this.logListeners, logLevelCache);
        this.propFunctionProvider = new MpPropFunctionProvider();
        this.propFunctionInvoker = new PropFunctionInvoker();
        this.rhinoFunctionInvoker = new RhinoFunctionInvoker(functionLoggerCreator);
        this.groovyFunctionInvoker = new GroovyFunctionInvoker(functionLoggerCreator, this.groovySecured, this.groovyIndyCompilation);
        this.flowInvoker = new FlowInvoker(this.groovyFunctionInvoker);
        if (this.supportedPython) {
            this.pythonFunctionInvoker = this.createPythonFunctionInvoker(functionLoggerCreator);
        }
        this.preparedParamCache = new MapPreparedParamCache();
        this.functionCache = new MapFunctionCache();
        HigsonDataSource higsonDataSource = this.higsonDataSource;
        if (higsonDataSource instanceof HigsonDbDataSource) {
            HigsonDbDataSource db = (HigsonDbDataSource)higsonDataSource;
            connectionInterceptor = db.getConnectionInterceptor();
        } else {
            connectionInterceptor = null;
        }
        ConnectionInterceptor connectionInterceptor2 = connectionInterceptor;
        OrtEnvironment environment = OrtEnvironment.getEnvironment();
        AiModelExecutor aiModelExecutor = new AiModelExecutor(environment);
        ParameterAiModelServiceImpl parameterAiModelService = new ParameterAiModelServiceImpl(environment, aiModelExecutor);
        this.parameterProvider = new MpParameterProvider(this.higsonDataSource.getParamDao(), this.externalStorageDao, this.maxConcurrentLoads, this.externalDataSourceProvider, connectionInterceptor2, parameterAiModelService);
        this.functionProvider = new MpFunctionProvider(this.higsonDataSource.getFunctionDao());
        this.profileCache = new ProfileCache();
        this.profileProvider = new ProfileProvider(this.profileCache, this.higsonDataSource.getVersionDao());
        this.versionInterceptor = new RuntimeVersionInterceptor(this.scheduleProvider, this.profileProvider);
        this.higsonDataSource.setParamInterceptor(this.versionInterceptor);
        TypesDto typesDto = TypesDto.builder().stringType(new StringType()).numberType(new NumberType()).integerType(new IntegerType()).booleanType(new BooleanType()).dateType(new DateType()).datetimeType(new DatetimeType()).localDateType(new LocalDateType()).localDateTimeType(new LocalDateTimeType()).build();
        HigsonContext.initialize(typesDto);
        CachingDateParser.setCacheSize(this.dateCacheSize);
        CachingNumberParser.setCacheSize(this.numberCacheSize);
        ParamEngineConfig conf = this.prepareEngineConfiguration();
        ParamEngine paramEngine = new ParamEngineFactory().createParamEngine(conf);
        log.debug("created core engine: {}", (Object)paramEngine);
        this.handleDeveloperMode();
        this.createDomainCache();
        log.debug("using value-never-null mode: {}", (Object)this.valueNeverNull);
        HigsonEngineImpl engine = new HigsonEngineImpl(paramEngine, this.domainCache, this.versionInterceptor, this.valueNeverNull);
        this.flowInvoker.setHigsonEngine(engine);
        functionLoggerCreator.setHigsonEngine(engine);
        if (!this.decodingStrategy.hasEngineConfigured()) {
            this.decodingStrategy.setEngine(engine);
        }
        if (this.enableDomainCache) {
            log.debug("creating domain cache component...");
            this.setupDomainCacheComponent(this.domainCache, engine);
        }
        this.registerRhinoPlugins(engine);
        this.registerGroovyPlugins(engine);
        if (this.supportedPython) {
            this.registerPythonPlugins(engine);
        }
        if (this.levelCreatorInterceptor == null) {
            this.levelCreatorInterceptor = new StdFunctionInterceptor(engine);
        }
        if (paramEngine instanceof SmartParamEngine) {
            log.debug("installing function invocation interceptor");
            ((SmartParamEngine)paramEngine).setInvokerInterceptor(this.levelCreatorInterceptor);
        }
        this.createInitializers(engine);
        this.createReloader();
        if (this.autoStartWatchers && !this.isSnapshotDatasource()) {
            log.debug("automatically starting runtime watchers...");
            this.startParamWatcher(this.watchersConfig.getParamWatcherConfig());
            this.startFunctionWatcher(this.watchersConfig.getFunctionWatcherConfig());
            this.startDomainWatcher(this.watchersConfig.getDomainWatcherConfig());
            this.startVersionWatcher(this.watchersConfig.getVersionWatcherConfig());
            this.startProfileWatcher(this.watchersConfig.getProfileWatcherConfig());
            this.startUserRegionVersionRuntimeWatcher(this.watchersConfig.getUserRegionVersionWatcherConfig());
            this.startScheduleWatcher();
            this.startRefreshWatcher(this.watchersConfig.getRefreshWatcherConfig());
        }
        log.info("successfully created Higson Runtime component.");
        this.startPrefetchers(engine);
        return engine;
    }

    private boolean isSnapshotDatasource() {
        return this.higsonDataSource instanceof HigsonSnapshotDataSource;
    }

    private PythonFunctionInvoker createPythonFunctionInvoker(FunctionLoggerCreator functionLoggerCreator) {
        if (CollectionUtils.isNotEmpty(this.sharedModules)) {
            return PythonFunctionInvoker.invokerWithExtraModules(this.sharedModules, functionLoggerCreator);
        }
        return PythonFunctionInvoker.defaultInvoker(functionLoggerCreator);
    }

    private ParamEngineConfig prepareEngineConfiguration() {
        this.splitter = new CachingSplitter(',', this.splitterCacheSize);
        this.tokenSeparator = new BetweenMatcherTokenSeparator(this.betweenMatcherCacheSize);
        ParamEngineConfigBuilder builder = ParamEngineConfigBuilder.paramEngineConfig().withAnnotationScanDisabled().withParameterRepositories(this.parameterProvider).withFunctionRepository("repo:prop", 110, this.propFunctionProvider).withFunctionRepository("repo:java", 120, this.functionProvider).withFunctionInvoker("prop", this.propFunctionInvoker).withFunctionInvoker("rhino", this.rhinoFunctionInvoker).withFunctionInvoker("groovy", this.groovyFunctionInvoker).withFunctionInvoker("flow", this.flowInvoker).withFunctionInvoker("python", this.pythonFunctionInvoker, this.supportedPython).withFunctionInvocationInterceptors(this.functionInvocationInterceptors).withParameterCache(this.preparedParamCache).withFunctionCache(this.functionCache).withType("number", HigsonContext.getNumberType()).withType("integer", HigsonContext.getIntegerType()).withType("string", HigsonContext.getStringType()).withType("boolean", HigsonContext.getBooleanType()).withType("date", HigsonContext.getDateType()).withType("datetime", HigsonContext.getDatetimeType()).withType("localDate", HigsonContext.getLocalDateType()).withType("localDateTime", HigsonContext.getLocalDateTimeType()).withMatcher("between/ie", new BetweenMatcher(true, false, this.tokenSeparator)).withMatcher("between/ei", new BetweenMatcher(false, true, this.tokenSeparator)).withMatcher("between/ii", new BetweenMatcher(true, true, this.tokenSeparator)).withMatcher("in", new InMatcher(this.splitter)).withMatcher("not-in", new NotInMatcher(this.splitter)).withMatcher("contains/any", new ContainsAnyMatcher()).withMatcher("contains/all", new ContainsAllMatcher()).withMatcher("contains/none", new ContainsNoneMatcher()).withMatcher("text/regex", new RegexMatcher()).withMatcher("text/like", new LikeMatcher()).withOutputLevelArraySeparator(this.outputLevelArraySeparator).withIdleChecker(this.idleChecker).withProperties(this.properties);
        log.info("using idle checker: {}", (Object)this.idleChecker);
        if (this.validateFunctionArgumentsDataTypes) {
            builder.withFunctionInvocationInterceptor(new FunctionArgumentDataTypeValidator());
        }
        return builder.build();
    }

    private void registerPythonPlugins(HigsonEngineImpl engine) {
        this.pythonFunctionInvoker.addGlobalObject(FunctionCode.HYPERON, new RhinoHigson(engine));
    }

    private void registerGroovyPlugins(HigsonEngineImpl engine) {
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.STR, (Object)RhinoStr.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.UTIL, (Object)RhinoUtil.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.MATH, (Object)RhinoMath.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.DATE, (Object)RhinoDate.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.TYPE, (Object)new RhinoType());
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.MPP, (Object)new RhinoHigson(engine));
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.HYPERON, (Object)new RhinoHigson(engine));
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.HIGSON, (Object)new RhinoHigson(engine));
        if (this.enableDomainCache) {
            this.groovyFunctionInvoker.addGlobalObject(FunctionCode.DOMAIN, (Object)new RhinoDomain(engine));
        }
        if (this.customPlugins != null) {
            for (Map.Entry<String, Object> entry : this.customPlugins.entrySet()) {
                this.groovyFunctionInvoker.addGlobalObject(entry.getKey(), entry.getValue());
            }
        }
    }

    private void handleDeveloperMode() {
        if (this.developerMode) {
            log.info("runtime mode: dev");
            log.info("devmode user: {}", (Object)this.username);
            this.setupDeveloperMode();
        } else {
            log.info("runtime mode: production");
        }
    }

    private void setupDeveloperMode() {
        HigsonDataSource higsonDataSource = this.higsonDataSource;
        if (higsonDataSource instanceof HigsonDbDataSource) {
            HigsonDbDataSource dbDataSource = (HigsonDbDataSource)higsonDataSource;
            DevModeJdbcDao dao = new DevModeJdbcDao(dbDataSource.getDataSource(), dbDataSource.getConnectionInterceptor());
            this.devModeProvider = new DevModeProvider(dao, this.scheduleProvider);
            RuntimeVersionInterceptor runtimeVersionInterceptor = new RuntimeVersionInterceptor(this.scheduleProvider, this.profileProvider);
            DevModePerspective devModePerspective = new DevModePerspective(this.devModeProvider, runtimeVersionInterceptor);
            this.versionInterceptor = new DeveloperModeInterceptor(runtimeVersionInterceptor, devModePerspective, this.username);
            this.sessionProvider = new DevModeUserProvider(this.username);
            this.higsonDataSource.setParamInterceptor(this.versionInterceptor);
            this.devModeWatcher = new DevModeWatcher(this.devModeProvider);
            this.devModeWatcher.setConfig(this.watchersConfig.getDevModeWatcherConfig());
            if (this.autoStartWatchers) {
                this.devModeWatcher.start();
            }
        } else {
            log.warn("Debug mode not supported for dataSource " + this.higsonDataSource);
        }
    }

    private void createDomainCache() {
        if (this.domainCache == null) {
            this.domainCache = new MpDomainCache();
        }
    }

    private void setupDomainCacheComponent(DomainCache domain, HigsonEngineImpl engine) {
        if (this.attributeInterceptor != null) {
            log.info("using domain attribute interceptor: {}", (Object)this.attributeInterceptor);
        }
        AttributeValueResolver resolver = new AttributeValueResolver(engine);
        AttributeValueProvider provider = new AttributeValueProvider(resolver, this.attributeInterceptor);
        if (this.domainCacheManager == null) {
            this.domainCacheProvider = new MpDomainCacheProvider(this.higsonDataSource.getDomainCacheJdbcDao(), this.effectiveVersionResolver, this.userRegionVersionProvider, provider);
            this.domainCacheManager = new MpDomainCacheManager(this.domainCacheProvider, this.effectiveVersionResolver, new MpDomainRefreshController(this.higsonDataSource.getDomainCacheJdbcDao()));
        } else {
            this.domainCacheProvider.setAttributeValueProvider(provider);
        }
        domain.setup(this.domainCacheManager);
        domain.setUserSessionProvider(this.sessionProvider);
        domain.setVersionJdbcDao(this.higsonDataSource.getVersionDao());
    }

    private void registerRhinoPlugins(HigsonEngineImpl engine) {
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.STR, (Object)RhinoStr.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.UTIL, (Object)RhinoUtil.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.MATH, (Object)RhinoMath.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.DATE, (Object)RhinoDate.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.TYPE, (Object)new RhinoType());
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.MPP, (Object)new RhinoHigson(engine));
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.HYPERON, (Object)new RhinoHigson(engine));
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.HIGSON, (Object)new RhinoHigson(engine));
        if (this.enableDomainCache) {
            this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.DOMAIN, (Object)new RhinoDomain(engine));
        }
        if (this.customPlugins != null) {
            for (Map.Entry<String, Object> entry : this.customPlugins.entrySet()) {
                this.rhinoFunctionInvoker.addGlobalObject(entry.getKey(), entry.getValue());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("rhino invoker initialized with such global objects: {}", (Object)Printer.print(this.rhinoFunctionInvoker.getGlobalObjects().entrySet(), "global variables"));
        }
    }

    private void printExternalDataSources() {
        log.info("default datasource: {}", (Object)this.higsonDataSource.datasourceInfo());
        for (String code : this.externalDataSourceProvider.listExternalDataSources()) {
            DataSource ext = this.externalDataSourceProvider.getDataSource(code);
            log.info("external datasource: {} -> {}", (Object)code, (Object)ext);
        }
    }

    public ParamRuntimeWatcher startParamWatcher(WatcherConfig config) {
        this.paramRuntimeWatcher = new ParamRuntimeWatcher(this.parameterProvider, this.preparedParamCache, this.devModeProvider, this.higsonDataSource.getSessionDao(), this.reloader);
        this.paramRuntimeWatcher.setConfig(config);
        this.paramRuntimeWatcher.setEventListener(this.watcherEventListener);
        this.paramRuntimeWatcher.start();
        return this.paramRuntimeWatcher;
    }

    public FunctionRuntimeWatcher startFunctionWatcher(WatcherConfig config) {
        this.functionRuntimeWatcher = new FunctionRuntimeWatcher(this.functionProvider, this.functionCache, this.groovyFunctionInvoker, this.functionInitializerImpl);
        this.functionRuntimeWatcher.setConfig(config);
        this.functionRuntimeWatcher.setEventListener(this.watcherEventListener);
        this.functionRuntimeWatcher.start();
        return this.functionRuntimeWatcher;
    }

    public VersionRuntimeWatcher startVersionWatcher(WatcherConfig config) {
        this.versionRuntimeWatcher = this.createVersionWatcher(config);
        this.versionRuntimeWatcher.start();
        return this.versionRuntimeWatcher;
    }

    public VersionRuntimeWatcher createVersionWatcher(WatcherConfig config) {
        this.versionRuntimeWatcher = new VersionRuntimeWatcher(this.higsonDataSource.getVersionDao(), this.functionCache, this.preparedParamCache, this.systemVersionCache, this.userRegionVersionCache);
        this.versionRuntimeWatcher.setConfig(config);
        return this.versionRuntimeWatcher;
    }

    private ProfileRuntimeWatcher startProfileWatcher(WatcherConfig config) {
        this.profileRuntimeWatcher = new ProfileRuntimeWatcher(this.higsonDataSource.getVersionDao(), this.profileCache);
        this.profileRuntimeWatcher.setConfig(config);
        this.profileRuntimeWatcher.start();
        return this.profileRuntimeWatcher;
    }

    private UserRegionVersionRuntimeWatcher startUserRegionVersionRuntimeWatcher(WatcherConfig config) {
        this.userRegionVersionRuntimeWatcher = this.createUserRegionVersionWatcher(config);
        this.userRegionVersionRuntimeWatcher.start();
        return this.userRegionVersionRuntimeWatcher;
    }

    public UserRegionVersionRuntimeWatcher createUserRegionVersionWatcher(WatcherConfig config) {
        UserRegionVersionRuntimeWatcher watcher = new UserRegionVersionRuntimeWatcher(this.higsonDataSource.getVersionDao(), this.userRegionVersionCache);
        watcher.setConfig(config);
        return watcher;
    }

    public ScheduleRuntimeWatcher startScheduleWatcher() {
        this.scheduleRuntimeWatcher = new ScheduleRuntimeWatcher(this.scheduleProvider);
        this.scheduleRuntimeWatcher.setConfig(this.watchersConfig.getScheduleRuntimeWatcherConfig());
        this.scheduleRuntimeWatcher.start();
        return this.scheduleRuntimeWatcher;
    }

    public RefreshRuntimeWatcher startRefreshWatcher(WatcherConfig config) {
        this.refreshRuntimeWatcher = new RefreshRuntimeWatcher(this.preparedParamCache);
        this.refreshRuntimeWatcher.setConfig(config);
        this.refreshRuntimeWatcher.start();
        return this.refreshRuntimeWatcher;
    }

    public DomainRuntimeWatcher startDomainWatcher(WatcherConfig watcherConf) {
        if (this.enableDomainCache) {
            this.domainRuntimeWatcher = new DomainRuntimeWatcher((WatcherDomainCacheManager)this.domainCacheManager);
            this.domainRuntimeWatcher.setConfig(watcherConf);
            this.domainRuntimeWatcher.start();
        }
        return this.domainRuntimeWatcher;
    }

    private void startPrefetchers(HigsonEngine engine) {
        if (CollectionUtils.isNotEmpty(this.paramsToPrefetch)) {
            this.startParameterPrefetch(engine);
        }
        if (CollectionUtils.isNotEmpty(this.functionsToPrefetch)) {
            this.startFunctionPrefetch(engine);
        }
        if (!this.profileToRegionsForParametersPrefetch.isEmpty()) {
            this.startParametersByRegionsPrefetch(engine);
        }
    }

    private void createInitializers(HigsonEngine engine) {
        this.paramInitializerImpl = new ParamInitializerImpl(engine);
        this.functionInitializerImpl = new FunctionInitializerImpl(engine, this.higsonDataSource.getFunctionDao());
    }

    private void createReloader() {
        if (this.reloadPolicy == null) {
            this.reloadPolicy = new NoneReloadPolicy();
            this.reloader = new NopReloader();
        } else {
            this.asyncReloader = new AsyncReloader(this.paramInitializerImpl);
            this.reloader = new DefaultReloader(this.higsonDataSource.getVersionDao(), this.higsonDataSource.getParamDao(), this.reloadPolicy, this.asyncReloader);
        }
        log.info("created param reloader: {}", (Object)this.reloader);
        log.info("using reloading policy: {}", (Object)this.reloadPolicy);
    }

    private void startParameterPrefetch(HigsonEngine engine) {
        log.debug("startParameterPrefetch, starting to process parameters (async) ...");
        SimplePrefetchStrategy prefetchStrategy = new SimplePrefetchStrategy(this.paramInitializerImpl, this.paramsToPrefetch);
        PrefetchStrategyAsyncExecutor.execute(prefetchStrategy);
    }

    private void startParametersByRegionsPrefetch(HigsonEngine engine) {
        log.debug("startParametersByRegionsPrefetch, starting to process parameters (async) ...");
        ParamInitializerImpl initializer = new ParamInitializerImpl(engine);
        ParametersByRegionsPrefetchStrategy prefetchStrategy = new ParametersByRegionsPrefetchStrategy(initializer, this.higsonDataSource.getParamDao(), this.profileToRegionsForParametersPrefetch);
        PrefetchStrategyAsyncExecutor.execute(prefetchStrategy);
    }

    private void startFunctionPrefetch(HigsonEngine engine) {
        log.debug("starting to process functions (async) ...");
        SimplePrefetchStrategy prefetchStrategy = new SimplePrefetchStrategy(this.functionInitializerImpl, this.functionsToPrefetch);
        PrefetchStrategyAsyncExecutor.execute(prefetchStrategy);
    }

    public void destroy() {
        BaseWatcher[] watchers;
        log.info("closing higson-runtime components...");
        if (this.asyncReloader != null) {
            this.asyncReloader.close();
        }
        for (BaseWatcher watcher : watchers = new BaseWatcher[]{this.paramRuntimeWatcher, this.functionRuntimeWatcher, this.versionRuntimeWatcher, this.profileRuntimeWatcher, this.userRegionVersionRuntimeWatcher, this.scheduleRuntimeWatcher, this.domainRuntimeWatcher, this.devModeWatcher, this.refreshRuntimeWatcher}) {
            if (watcher == null) continue;
            watcher.stop();
        }
        if (this.preparedParamCache != null) {
            this.preparedParamCache.invalidate();
        }
    }

    public void setLevelCreatorInterceptor(FunctionInvokerInterceptor levelCreatorInterceptor) {
        this.levelCreatorInterceptor = levelCreatorInterceptor;
    }

    @Deprecated(forRemoval=true)
    public void setEnableDomainCache(boolean enableDomainCache) {
        this.enableDomainCache = enableDomainCache;
    }

    public void setAttributeInterceptor(AttributeInterceptor attributeInterceptor) {
        this.attributeInterceptor = attributeInterceptor;
    }

    public void setWatcherEventListener(WatcherEventListener watcherEventListener) {
        this.watcherEventListener = watcherEventListener;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setValidateFunctionArgumentsDataTypes(boolean validateFunctionArgumentsDataTypes) {
        this.validateFunctionArgumentsDataTypes = validateFunctionArgumentsDataTypes;
    }

    public Optional<PythonFunctionInvoker> getPythonFunctionInvoker() {
        return this.supportedPython ? Optional.of(this.pythonFunctionInvoker) : Optional.empty();
    }

    public void addExternalDataSources(Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<String, DataSource> e : dataSourceMap.entrySet()) {
            this.addExternalDataSource(e.getKey(), e.getValue());
        }
    }

    public void addExternalDataSource(String code, DataSource dataSource) {
        this.externalDataSourceProvider.withExternalDataSource(code, dataSource);
    }

    public void setExternalDataSources(Map<String, DataSource> map) {
        for (Map.Entry<String, DataSource> e : map.entrySet()) {
            this.addExternalDataSource(e.getKey(), e.getValue());
        }
    }

    public void redefineDomainCache(DomainCache newMpDomainCache, MpDomainCacheProvider newDomainCacheProvider, DomainCacheManager newDomainCacheManager) {
        this.domainCache = newMpDomainCache;
        this.domainCacheProvider = newDomainCacheProvider;
        this.domainCacheManager = newDomainCacheManager;
    }

    public void setExternalModulesForPython(List<String> modules) {
        this.sharedModules = modules;
    }

    public void setThrowOnNormalizeInputValueException(boolean throwOnNormalizeInputValueException) {
        this.properties.setThrowOnNormalizeInputValueException(throwOnNormalizeInputValueException);
    }

    public void addFunctionInvocationInterceptor(FunctionInvocationInterceptor functionInvocationInterceptor) {
        this.functionInvocationInterceptors.add(functionInvocationInterceptor);
    }

    public void setFunctionLogLevelCacheTTL(Duration ttl) {
        this.functionLogLevelCacheTTL = ttl;
    }

    public void attachLogListener(LogListener logListener) {
        this.logListeners.add(logListener);
    }

    public void setIdleChecker(IdleChecker idleChecker) {
        this.idleChecker = idleChecker;
    }

    public void setMaxIdleTime(Duration maxIdleTime) {
        this.idleChecker = new DefaultIdleChecker(maxIdleTime.toMillis());
    }

    public void setReloadPolicy(ReloadPolicy reloadPolicy) {
        this.reloadPolicy = reloadPolicy;
    }

    @Deprecated(forRemoval=true)
    public int getWatcherStartDelaySeconds() {
        return this.watchersConfig.getParamWatcherConfig().getStartDelaySeconds();
    }

    @Deprecated(forRemoval=true)
    public int getWatcherPauseSeconds() {
        return this.watchersConfig.getParamWatcherConfig().getWatcherPauseSeconds();
    }

    @Deprecated(forRemoval=true)
    public int getWatcherErrorPauseSeconds() {
        return this.watchersConfig.getParamWatcherConfig().getErrorPauseSeconds();
    }

    @Deprecated(forRemoval=true)
    public int getScheduleWatcherPauseSeconds() {
        return this.watchersConfig.getScheduleRuntimeWatcherConfig().getWatcherPauseSeconds();
    }

    @Deprecated(forRemoval=true)
    public WatcherConfig getRefreshWatcherConfig() {
        return this.watchersConfig.getRefreshWatcherConfig();
    }

    @Deprecated(forRemoval=true)
    public WatcherConfig getParamWatcherConfig() {
        return this.watchersConfig.getParamWatcherConfig();
    }

    @Deprecated(forRemoval=true)
    public WatcherConfig getFunctionWatcherConfig() {
        return this.watchersConfig.getParamWatcherConfig();
    }

    @Deprecated(forRemoval=true)
    public void setWatcherStartDelaySeconds(int watcherStartDelaySeconds) {
        this.watchersConfig.getParamWatcherConfig().delay(watcherStartDelaySeconds);
        this.watchersConfig.getFunctionWatcherConfig().delay(watcherStartDelaySeconds);
        this.watchersConfig.getDomainWatcherConfig().delay(watcherStartDelaySeconds);
        this.watchersConfig.getDevModeWatcherConfig().delay(watcherStartDelaySeconds);
        this.watchersConfig.getVersionWatcherConfig().delay(watcherStartDelaySeconds);
        this.watchersConfig.getProfileWatcherConfig().delay(watcherStartDelaySeconds);
        this.watchersConfig.getUserRegionVersionWatcherConfig().delay(watcherStartDelaySeconds);
    }

    @Deprecated(forRemoval=true)
    public void setWatcherPauseSeconds(int watcherPauseSeconds) {
        this.watchersConfig.getParamWatcherConfig().pause(watcherPauseSeconds);
        this.watchersConfig.getFunctionWatcherConfig().pause(watcherPauseSeconds);
        this.watchersConfig.getDomainWatcherConfig().pause(watcherPauseSeconds);
        this.watchersConfig.getVersionWatcherConfig().pause(watcherPauseSeconds);
        this.watchersConfig.getProfileWatcherConfig().pause(watcherPauseSeconds);
        this.watchersConfig.getUserRegionVersionWatcherConfig().pause(watcherPauseSeconds);
    }

    @Deprecated(forRemoval=true)
    public void setWatcherErrorPauseSeconds(int watcherErrorPauseSeconds) {
        this.watchersConfig.getParamWatcherConfig().error(watcherErrorPauseSeconds);
        this.watchersConfig.getFunctionWatcherConfig().error(watcherErrorPauseSeconds);
        this.watchersConfig.getDomainWatcherConfig().error(watcherErrorPauseSeconds);
        this.watchersConfig.getDevModeWatcherConfig().error(watcherErrorPauseSeconds);
        this.watchersConfig.getVersionWatcherConfig().error(watcherErrorPauseSeconds);
        this.watchersConfig.getProfileWatcherConfig().error(watcherErrorPauseSeconds);
        this.watchersConfig.getUserRegionVersionWatcherConfig().error(watcherErrorPauseSeconds);
    }

    @Deprecated(forRemoval=true)
    public void setWatcherForceSyncSeconds(int seconds) {
        this.watchersConfig.getParamWatcherConfig().force(seconds);
    }

    @Deprecated(forRemoval=true)
    public void setRefreshWatcherConfig(WatcherConfig conf) {
        this.watchersConfig.setRefreshWatcherConfig(conf);
    }

    @Deprecated(forRemoval=true)
    public void setDomainWatcherInvalidateCacheTime(int domainWatcherInvalidateCacheTime, TemporalUnit unit) {
        this.watchersConfig.getDomainWatcherConfig().invalidate(domainWatcherInvalidateCacheTime, unit);
    }

    @Deprecated(forRemoval=true)
    public void setScheduleWatcherPauseSeconds(int scheduleWatcherPauseSeconds) {
        this.watchersConfig.getScheduleRuntimeWatcherConfig().pause(scheduleWatcherPauseSeconds);
    }

    public HigsonDataSource getHigsonDataSource() {
        return this.higsonDataSource;
    }

    public boolean isValueNeverNull() {
        return this.valueNeverNull;
    }

    public boolean isAutoStartWatchers() {
        return this.autoStartWatchers;
    }

    public boolean isEnableDomainCache() {
        return this.enableDomainCache;
    }

    public int getMaxConcurrentLoads() {
        return this.maxConcurrentLoads;
    }

    public WatchersConfig getWatchersConfig() {
        return this.watchersConfig;
    }

    public ExternalStorageDao getExternalStorageDao() {
        return this.externalStorageDao;
    }

    public MpParameterProvider getParameterProvider() {
        return this.parameterProvider;
    }

    public MpFunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    public MpPropFunctionProvider getPropFunctionProvider() {
        return this.propFunctionProvider;
    }

    public PropFunctionInvoker getPropFunctionInvoker() {
        return this.propFunctionInvoker;
    }

    public RhinoFunctionInvoker getRhinoFunctionInvoker() {
        return this.rhinoFunctionInvoker;
    }

    public GroovyFunctionInvoker getGroovyFunctionInvoker() {
        return this.groovyFunctionInvoker;
    }

    public FlowInvoker getFlowInvoker() {
        return this.flowInvoker;
    }

    public MpDecodingStrategy getDecodingStrategy() {
        return this.decodingStrategy;
    }

    public FunctionInvokerInterceptor getLevelCreatorInterceptor() {
        return this.levelCreatorInterceptor;
    }

    public DomainRuntimeWatcher getDomainRuntimeWatcher() {
        return this.domainRuntimeWatcher;
    }

    public MpDomainCacheProvider getDomainCacheProvider() {
        return this.domainCacheProvider;
    }

    public DomainCacheManager getDomainCacheManager() {
        return this.domainCacheManager;
    }

    public DomainCache getDomainCache() {
        return this.domainCache;
    }

    public ProfileProvider getProfileProvider() {
        return this.profileProvider;
    }

    public UserRegionVersionCache getUserRegionVersionCache() {
        return this.userRegionVersionCache;
    }

    public UserRegionVersionProvider getUserRegionVersionProvider() {
        return this.userRegionVersionProvider;
    }

    public ParamRuntimeWatcher getParamRuntimeWatcher() {
        return this.paramRuntimeWatcher;
    }

    public PreparedParamCache getPreparedParamCache() {
        return this.preparedParamCache;
    }

    public FunctionRuntimeWatcher getFunctionRuntimeWatcher() {
        return this.functionRuntimeWatcher;
    }

    public FunctionCache getFunctionCache() {
        return this.functionCache;
    }

    public VersionRuntimeWatcher getVersionRuntimeWatcher() {
        return this.versionRuntimeWatcher;
    }

    public ProfileRuntimeWatcher getProfileRuntimeWatcher() {
        return this.profileRuntimeWatcher;
    }

    public UserRegionVersionRuntimeWatcher getUserRegionVersionRuntimeWatcher() {
        return this.userRegionVersionRuntimeWatcher;
    }

    public VersionInterceptor getVersionInterceptor() {
        return this.versionInterceptor;
    }

    public EffectiveVersionResolver getEffectiveVersionResolver() {
        return this.effectiveVersionResolver;
    }

    public MpScheduleProvider getScheduleProvider() {
        return this.scheduleProvider;
    }

    public ScheduleRuntimeWatcher getScheduleRuntimeWatcher() {
        return this.scheduleRuntimeWatcher;
    }

    public RefreshRuntimeWatcher getRefreshRuntimeWatcher() {
        return this.refreshRuntimeWatcher;
    }

    public String getUsername() {
        return this.username;
    }

    public DevModeProvider getDevModeProvider() {
        return this.devModeProvider;
    }

    public DevModeWatcher getDevModeWatcher() {
        return this.devModeWatcher;
    }

    public List<String> getParamsToPrefetch() {
        return this.paramsToPrefetch;
    }

    public List<String> getFunctionsToPrefetch() {
        return this.functionsToPrefetch;
    }

    public AttributeInterceptor getAttributeInterceptor() {
        return this.attributeInterceptor;
    }

    public WatcherEventListener getWatcherEventListener() {
        return this.watcherEventListener;
    }

    public Duration getFunctionLogLevelCacheTTL() {
        return this.functionLogLevelCacheTTL;
    }

    public ExtSqlExecutor getExtSqlExecutor() {
        return this.extSqlExecutor;
    }

    public OutputLevelArraySeparator getOutputLevelArraySeparator() {
        return this.outputLevelArraySeparator;
    }

    public SystemVersionCache getSystemVersionCache() {
        return this.systemVersionCache;
    }

    public SystemVersionProvider getSystemVersionProvider() {
        return this.systemVersionProvider;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Collection<LogListener> getLogListeners() {
        return this.logListeners;
    }

    public Initializer getParamInitializerImpl() {
        return this.paramInitializerImpl;
    }

    public Initializer getFunctionInitializerImpl() {
        return this.functionInitializerImpl;
    }

    public IdleChecker getIdleChecker() {
        return this.idleChecker;
    }

    public ReloadPolicy getReloadPolicy() {
        return this.reloadPolicy;
    }

    public Reloader getReloader() {
        return this.reloader;
    }

    public AsyncReloader getAsyncReloader() {
        return this.asyncReloader;
    }

    public int getDateCacheSize() {
        return this.dateCacheSize;
    }

    public int getNumberCacheSize() {
        return this.numberCacheSize;
    }

    public int getSplitterCacheSize() {
        return this.splitterCacheSize;
    }

    public int getBetweenMatcherCacheSize() {
        return this.betweenMatcherCacheSize;
    }

    public CachingSplitter getSplitter() {
        return this.splitter;
    }

    public BetweenMatcherTokenSeparator getTokenSeparator() {
        return this.tokenSeparator;
    }

    public boolean isGroovyIndyCompilation() {
        return this.groovyIndyCompilation;
    }

    public HigsonEngineFactory() {
    }

    public void setGroovySecured(boolean groovySecured) {
        this.groovySecured = groovySecured;
    }

    public void setSupportedPython(boolean supportedPython) {
        this.supportedPython = supportedPython;
    }

    public void setOutputLevelArraySeparator(OutputLevelArraySeparator outputLevelArraySeparator) {
        this.outputLevelArraySeparator = outputLevelArraySeparator;
    }

    public void setDateCacheSize(int dateCacheSize) {
        this.dateCacheSize = dateCacheSize;
    }

    public void setNumberCacheSize(int numberCacheSize) {
        this.numberCacheSize = numberCacheSize;
    }

    public void setSplitterCacheSize(int splitterCacheSize) {
        this.splitterCacheSize = splitterCacheSize;
    }

    public void setBetweenMatcherCacheSize(int betweenMatcherCacheSize) {
        this.betweenMatcherCacheSize = betweenMatcherCacheSize;
    }

    public void setGroovyIndyCompilation(boolean groovyIndyCompilation) {
        this.groovyIndyCompilation = groovyIndyCompilation;
    }
}

