/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.database;

import io.higson.runtime.core.datasource.HigsonDataSource;
import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.dao.DomainCacheJdbcDao;
import io.higson.runtime.dao.FunctionJdbcDao;
import io.higson.runtime.dao.SessionJdbcDao;
import io.higson.runtime.dao.VersionJdbcDao;
import io.higson.runtime.dao.parameter.ParameterJdbcDao;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.dao.util.StdConnectionInterceptor;
import io.higson.runtime.decoder.MpDecodingStrategy;
import io.higson.runtime.provider.external.ExtSqlExecutor;
import io.higson.runtime.sql.DialectRegistry;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public class HigsonDbDataSource
implements HigsonDataSource {
    private final DataSource dataSource;
    private final ConnectionInterceptor connectionInterceptor;
    private final FunctionJdbcDao functionDao;
    private final VersionJdbcDao versionDao;
    private final SessionJdbcDao sessionDao;
    private ParameterJdbcDao paramDao;
    private DomainCacheJdbcDao domainCacheJdbcDao;
    private String dialect;
    private String dbSchema;

    public HigsonDbDataSource(DataSource dataSource) {
        this(dataSource, null);
    }

    public HigsonDbDataSource(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.dataSource = dataSource;
        this.setupDialectRegistry();
        if (connectionInterceptor == null) {
            connectionInterceptor = new StdConnectionInterceptor();
        }
        this.connectionInterceptor = connectionInterceptor;
        this.versionDao = new VersionJdbcDao(dataSource, connectionInterceptor);
        this.sessionDao = new SessionJdbcDao(dataSource, connectionInterceptor);
        this.functionDao = new FunctionJdbcDao(dataSource, connectionInterceptor);
    }

    @Override
    public void setDataSource(MpDecodingStrategy decodingStrategy, ExtSqlExecutor extSqlExecutor) {
        this.paramDao = new ParameterJdbcDao(this.dataSource, this.connectionInterceptor, decodingStrategy, extSqlExecutor);
        this.domainCacheJdbcDao = new DomainCacheJdbcDao(this.dataSource, this.connectionInterceptor, this.versionDao);
    }

    private void setupDialectRegistry() {
        if (DialectRegistry.getDialect() == null) {
            DialectRegistry.set(this.dialect != null ? this.dialect : DialectRegistry.DEFAULT_DIALECT);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.dbSchema)) {
            DialectRegistry.setSchema(this.dbSchema);
        }
    }

    @Override
    public VersionJdbcDao getVersionDao() {
        return this.versionDao;
    }

    @Override
    public ParameterJdbcDao getParamDao() {
        return this.paramDao;
    }

    @Override
    public FunctionJdbcDao getFunctionDao() {
        return this.functionDao;
    }

    @Override
    public SessionJdbcDao getSessionDao() {
        return this.sessionDao;
    }

    @Override
    public DomainCacheJdbcDao getDomainCacheJdbcDao() {
        return this.domainCacheJdbcDao;
    }

    @Override
    public void setParamInterceptor(VersionInterceptor versionInterceptor) {
        this.paramDao.setInterceptor(versionInterceptor);
    }

    @Override
    public String datasourceInfo() {
        return this.dataSource.toString();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ConnectionInterceptor getConnectionInterceptor() {
        return this.connectionInterceptor;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }
}

