/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot;

import io.higson.runtime.core.datasource.DomainCacheDao;
import io.higson.runtime.core.datasource.FunctionDao;
import io.higson.runtime.core.datasource.HigsonDataSource;
import io.higson.runtime.core.datasource.SessionDao;
import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.core.datasource.snapshot.SnapshotSessionDao;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotDomainCacheDao;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotDomainDirReader;
import io.higson.runtime.core.datasource.snapshot.function.SnapshotFunctionDao;
import io.higson.runtime.core.datasource.snapshot.function.SnapshotFunctionReader;
import io.higson.runtime.core.datasource.snapshot.parameter.SnapshotParameterDao;
import io.higson.runtime.core.datasource.snapshot.parameter.SnapshotParameterReader;
import io.higson.runtime.core.datasource.snapshot.reader.SnapshotDirReader;
import io.higson.runtime.core.datasource.snapshot.reader.SnapshotReader;
import io.higson.runtime.core.datasource.snapshot.reader.SnapshotZipReader;
import io.higson.runtime.core.datasource.snapshot.version.SnapshotVersionDao;
import io.higson.runtime.core.datasource.snapshot.version.SnapshotVersionsReader;
import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.dao.parameter.ParameterDao;
import io.higson.runtime.decoder.MpDecodingStrategy;
import io.higson.runtime.provider.external.ExtSqlExecutor;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class HigsonSnapshotDataSource
implements HigsonDataSource {
    private static final String ZIP_EXTENSION = "zip";
    private final SessionDao snapshotSessionDao = new SnapshotSessionDao();
    private final VersionDao versionDao;
    private final FunctionDao functionDao;
    private final SnapshotParameterDao parameterDao;
    private final DomainCacheDao domainCacheDao;
    private final String datasourceInfo;

    public HigsonSnapshotDataSource(File snapshotDir) {
        SnapshotReader reader = HigsonSnapshotDataSource.getSnapshotReader(snapshotDir);
        this.versionDao = new SnapshotVersionDao(new SnapshotVersionsReader(snapshotDir, reader));
        this.functionDao = new SnapshotFunctionDao(new SnapshotFunctionReader(snapshotDir, reader), this.versionDao);
        this.parameterDao = new SnapshotParameterDao(new SnapshotParameterReader(snapshotDir, reader), this.versionDao);
        this.domainCacheDao = new SnapshotDomainCacheDao(new SnapshotDomainDirReader(snapshotDir, reader), this.versionDao);
        this.datasourceInfo = snapshotDir.toString();
    }

    @Override
    public void setDataSource(MpDecodingStrategy decodingStrategy, ExtSqlExecutor extSqlExecutor) {
        this.parameterDao.setDecodingStrategy(decodingStrategy);
    }

    @Override
    public SessionDao getSessionDao() {
        return this.snapshotSessionDao;
    }

    @Override
    public FunctionDao getFunctionDao() {
        return this.functionDao;
    }

    @Override
    public ParameterDao getParamDao() {
        return this.parameterDao;
    }

    @Override
    public VersionDao getVersionDao() {
        return this.versionDao;
    }

    @Override
    public DomainCacheDao getDomainCacheJdbcDao() {
        return this.domainCacheDao;
    }

    @Override
    public void setParamInterceptor(VersionInterceptor versionInterceptor) {
    }

    @Override
    public String datasourceInfo() {
        return this.datasourceInfo;
    }

    private static SnapshotReader getSnapshotReader(File snapshotDir) {
        return ZIP_EXTENSION.equals(FilenameUtils.getExtension((String)snapshotDir.getName())) ? new SnapshotZipReader(snapshotDir.toPath()) : new SnapshotDirReader();
    }
}

