/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Messages {
    private static final Logger log = LoggerFactory.getLogger(Messages.class);
    private static final String BUNDLE_NAME = "pl.decerto.mpp.core.messages";
    private static final String SUPERPACK_BUNDLE_NAME = "pl.decerto.mpp.core.superpack";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("pl.decerto.mpp.core.messages");
    private static final ResourceBundle ENUM_RESOURCE_BUNDLE = ResourceBundle.getBundle("pl.decerto.mpp.core.messages-enum");
    private static final ResourceBundle SUPERPACK_BUNDLE = ResourceBundle.getBundle("pl.decerto.mpp.core.superpack");
    private static final Locale[] LANGUAGES = new Locale[]{Locale.ROOT, new Locale("pl")};
    private static final ResourceBundle[] LOCALE_BUNDLES = new ResourceBundle[LANGUAGES.length];

    private Messages() {
        throw new IllegalStateException();
    }

    private static String getMessageFromBundle(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            log.error("", (Throwable)e);
            return "!" + key + "!";
        }
    }

    public static String message(String key, Object ... params) {
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), params);
        }
        catch (MissingResourceException e) {
            log.error("", (Throwable)e);
            return "!" + key + "!";
        }
    }

    public static String message(String key) {
        return Messages.getMessageFromBundle(key, RESOURCE_BUNDLE);
    }

    public static String enumMessage(Enum<?> enumValue) {
        return Messages.getMessageFromBundle(enumValue.getClass().getCanonicalName() + "." + enumValue.name(), ENUM_RESOURCE_BUNDLE);
    }

    public static List<String> multiMessage(String key) {
        ArrayList<String> multiLanguage = new ArrayList<String>(LANGUAGES.length);
        for (int i = 0; i < LANGUAGES.length; ++i) {
            if (LOCALE_BUNDLES[i] == null) {
                Messages.LOCALE_BUNDLES[i] = ResourceBundle.getBundle(BUNDLE_NAME, LANGUAGES[i]);
            }
            try {
                multiLanguage.add(LOCALE_BUNDLES[i].getString(key));
                continue;
            }
            catch (MissingResourceException e) {
                log.error("", (Throwable)e);
            }
        }
        return multiLanguage;
    }

    public static String superpackMessage(String key) {
        return Messages.getMessageFromBundle(key, SUPERPACK_BUNDLE);
    }
}

