/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.function;

import io.higson.runtime.core.datasource.snapshot.IncorrectSnapshotException;
import io.higson.runtime.core.datasource.snapshot.SnapshotPath;
import io.higson.runtime.core.datasource.snapshot.function.FunctionDetails;
import io.higson.runtime.core.datasource.snapshot.function.FunctionFileExtractor;
import io.higson.runtime.core.datasource.snapshot.function.FunctionMeta;
import io.higson.runtime.core.datasource.snapshot.function.FunctionNotFoundInSnapshotException;
import io.higson.runtime.core.datasource.snapshot.function.FunctionResult;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDataSourceConstants;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDirHelper;
import io.higson.runtime.core.datasource.snapshot.reader.SnapshotReader;
import io.higson.runtime.function.FunctionType;
import io.higson.runtime.model.region.ScheduleContainer;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFunctionReader {
    private static final Logger log = LoggerFactory.getLogger(SnapshotFunctionReader.class);
    private static final String VERSION_SEPARATOR = ":";
    private static final String GROOVY_EXTENSION = "groovy";
    private static final String PYTHON_EXTENSION = "py";
    private static final String RHINO_EXTENSION = "js";
    private final AtomicInteger idGenerator = new AtomicInteger(1);
    private final Map<String, FunctionMeta> functionsMeta = new HashMap<String, FunctionMeta>(64);
    private final File snapshotPath;
    private final SnapshotReader snapshotReader;
    private final FunctionFileExtractor functionFileExtractor = new FunctionFileExtractor();
    private boolean loaded = false;

    private static String[] getSegments(Path path) {
        String[] segments = SnapshotDataSourceConstants.PATH_SEPARATOR_PATTERN.split(path.toString());
        if (segments.length == 0) {
            throw new IncorrectSnapshotException("Incorrect snapshot path " + path);
        }
        return segments;
    }

    public FunctionDetails getFunction(String code, String version, Map<String, ScheduleContainer> allSchedules) {
        this.loadFunctions();
        try {
            FunctionMeta functionMeta = this.findFunction(code, version, allSchedules);
            FunctionResult functionResult = this.functionFileExtractor.readAttributesFromMatcher(functionMeta.path());
            return FunctionDetails.builder().id(functionMeta.id()).code(code).implId(functionMeta.implId()).body(functionResult.getBody()).type(functionMeta.type()).arguments(functionResult.getAttributes().getArguments()).categories(functionResult.getAttributes().getCategories()).logLevel(functionResult.getAttributes().getLogLevel()).description(functionResult.getAttributes().getDescription()).build();
        }
        catch (IOException e) {
            log.error("Cannot read function {} (version {}) in functions dir {}", new Object[]{code, version, this.snapshotPath.getPath(), e});
            throw new RuntimeException(e);
        }
    }

    public Map<String, FunctionMeta> getFunctionsMeta() {
        this.loadFunctions();
        return this.functionsMeta;
    }

    private FunctionMeta findFunction(String code, @Nullable String version, Map<String, ScheduleContainer> allSchedules) {
        FunctionMeta functionMeta = this.functionsMeta.get(this.functionUid(code, version));
        if (functionMeta == null && version == null) {
            return this.getFunctionFromAppropriateVersion(code, allSchedules);
        }
        if (functionMeta == null) {
            throw new FunctionNotFoundInSnapshotException(code, version, this.snapshotPath.getPath());
        }
        return functionMeta;
    }

    private FunctionMeta getFunctionFromAppropriateVersion(String code, Map<String, ScheduleContainer> allSchedules) {
        List<FunctionMeta> functions = this.findFunctionInAllVersions(code);
        if (functions.isEmpty()) {
            throw new FunctionNotFoundInSnapshotException(code, null, this.snapshotPath.getPath());
        }
        if (allSchedules == null) {
            return this.getInHighestVersion(functions);
        }
        FunctionMeta functionMeta = functions.get(0);
        String profile = functionMeta.profile();
        ScheduleContainer scheduleContainer = allSchedules.get(profile);
        if (scheduleContainer == null) {
            return this.getInHighestVersion(functions);
        }
        return scheduleContainer.getSchedule(functionMeta.region()).map(value -> value.find(new Date()).map(entry -> functions.stream().filter(f -> f.version().equals(entry.getVersion())).findAny().orElseGet(() -> this.getInHighestVersion(functions))).orElseGet(() -> this.getInHighestVersion(functions))).orElseGet(() -> this.getInHighestVersion(functions));
    }

    private FunctionMeta getInHighestVersion(List<FunctionMeta> functionsMeta) {
        return functionsMeta.stream().max(Comparator.comparingInt(p -> Integer.parseInt(p.version()))).get();
    }

    private List<FunctionMeta> findFunctionInAllVersions(String code) {
        return this.functionsMeta.entrySet().stream().filter(t -> ((String)t.getKey()).startsWith(code + VERSION_SEPARATOR)).map(Map.Entry::getValue).toList();
    }

    private synchronized void loadFunctions() {
        if (!this.loaded) {
            try (Stream<Path> stream = Files.walk(this.snapshotReader.getPath(this.snapshotPath.toPath(), SnapshotPath.FUNCTIONS.getPath()), new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(this.add());
            }
            catch (IOException e) {
                log.error("Cannot read functions in {}", (Object)this.snapshotPath.getPath(), (Object)e);
                throw new RuntimeException(e);
            }
            if (this.functionsMeta.isEmpty()) {
                log.warn("Cannot find functions in snapshot {}", (Object)this.snapshotPath);
            }
            this.loaded = true;
        }
    }

    private Consumer<? super Path> add() {
        return this::processPath;
    }

    private void processPath(Path path) {
        String[] segments = SnapshotFunctionReader.getSegments(path);
        String version = SnapshotDirHelper.getVersion(path, segments);
        String code = SnapshotDirHelper.getFullCode(path, segments, version);
        FunctionMeta functionMeta = FunctionMeta.builder().profile(SnapshotDirHelper.getProfile(path, segments)).region(SnapshotDirHelper.getRegion(path, segments)).version(version).code(code).type(this.getFunctionType(path)).path(path).id(this.idGenerator.incrementAndGet()).implId(this.idGenerator.get()).build();
        this.addFunctionMeta(code, version, functionMeta);
    }

    private FunctionType getFunctionType(Path path) {
        String extension;
        String fileName = path.getFileName().toString();
        return switch (extension = FilenameUtils.getExtension((String)fileName)) {
            case GROOVY_EXTENSION -> FunctionType.GROOVY;
            case PYTHON_EXTENSION -> FunctionType.PYTHON;
            case RHINO_EXTENSION -> FunctionType.RHINO;
            default -> throw new IncorrectSnapshotException("Unsupported functions with extension " + path.getFileName());
        };
    }

    private void addFunctionMeta(String code, String version, FunctionMeta functionMeta) {
        String functionUid = this.functionUid(code, version);
        if (this.functionsMeta.containsKey(functionUid)) {
            throw new IncorrectSnapshotException("Snapshot contains two functions with same name " + functionUid);
        }
        this.functionsMeta.put(functionUid, functionMeta);
    }

    private String functionUid(String code, @Nullable String version) {
        return version == null ? code : code + VERSION_SEPARATOR + version;
    }

    public SnapshotFunctionReader(File snapshotPath, SnapshotReader snapshotReader) {
        this.snapshotPath = snapshotPath;
        this.snapshotReader = snapshotReader;
    }
}

