/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.version;

import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDataSourceConstants;
import io.higson.runtime.core.datasource.snapshot.version.ScheduleDetails;
import io.higson.runtime.core.datasource.snapshot.version.SnapshotVersionsReader;
import io.higson.runtime.core.datasource.snapshot.version.VersionMeta;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.Schedule;
import io.higson.runtime.model.ScheduleEntry;
import io.higson.runtime.model.UserRegionVersion;
import io.higson.runtime.model.region.ScheduleContainer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotVersionDao
implements VersionDao {
    private static final Logger log = LoggerFactory.getLogger(SnapshotVersionDao.class);
    private final SnapshotVersionsReader snapshotVersionsDirReader;
    private List<VersionMeta> cachedVersions;
    private List<ScheduleDetails> cachedSchedule;

    @Override
    public Date getMaxLastUpdate() {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    private List<VersionMeta> getVersions() {
        if (this.cachedVersions == null) {
            this.cachedVersions = this.snapshotVersionsDirReader.getVersions();
        }
        return this.cachedVersions;
    }

    private List<ScheduleDetails> getSchedule() {
        if (this.cachedSchedule == null) {
            this.cachedSchedule = this.snapshotVersionsDirReader.getSchedule();
        }
        return this.cachedSchedule;
    }

    @Override
    public Map<Integer, RegionVersion> getAllRegionVersions() {
        return this.getVersions().stream().collect(Collectors.toMap(VersionMeta::versionId, this::buildRegionVersion));
    }

    private RegionVersion buildRegionVersion(VersionMeta vm) {
        return new RegionVersion(vm.versionId(), vm.regionId(), vm.region(), vm.version(), true, SnapshotDataSourceConstants.YEAR_AGO, vm.profile());
    }

    @Override
    public List<RegionVersion> getAllRegionVersionsList() {
        return this.getVersions().stream().map(this::buildRegionVersion).toList();
    }

    @Override
    public RegionVersion getRegionVersion(int regionVersionId) {
        return this.getVersions().stream().filter(rv -> rv.versionId() == regionVersionId).findFirst().map(this::buildRegionVersion).orElse(null);
    }

    @Override
    public List<RegionVersion> getAllRegionVersionsList(String profileCode) {
        return this.getVersions().stream().filter(rv -> Objects.equals(rv.profile(), profileCode)).map(this::buildRegionVersion).toList();
    }

    @Override
    public Set<String> getFunctionsWithRegion(int regionId) {
        throw new UnsupportedOperationException("getFunctionsWithRegion unsupported");
    }

    @Override
    public Set<String> getParametersWithRegion(int regionId) {
        throw new UnsupportedOperationException("getParametersWithRegion unsupported");
    }

    @Override
    public Map<String, ScheduleContainer> getAllSchedules() {
        return this.getSchedule().stream().collect(Collectors.groupingBy(ScheduleDetails::profile)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, scheduleList -> this.buildScheduleContainer((List)scheduleList.getValue())));
    }

    @Override
    public List<RegionVersion> getUserRegionVersions(String profileCode, String user) {
        throw new UnsupportedOperationException("getParametersWithRegion unsupported");
    }

    @Override
    public List<UserRegionVersion> getAllUserRegionVersions() {
        throw new UnsupportedOperationException("getParametersWithRegion unsupported");
    }

    @Override
    public SortedSet<Integer> getSystemVersions(String profile, SortedSet<Integer> versionsToOmit) {
        log.warn("System versions unsupported");
        return new TreeSet<Integer>();
    }

    @Override
    public List<String> getProfiles(String regionCode) {
        return this.getVersions().stream().filter(r -> Objects.equals(r.region(), regionCode)).map(VersionMeta::profile).distinct().toList();
    }

    @Override
    public List<String> getProfiles(String regionCode, String version) {
        return this.getVersions().stream().filter(i -> Objects.equals(i.region(), regionCode) && Objects.equals(i.version(), version)).map(VersionMeta::profile).distinct().toList();
    }

    private ScheduleContainer buildScheduleContainer(List<ScheduleDetails> scheduleList) {
        ScheduleContainer scheduleContainer = new ScheduleContainer();
        scheduleList.forEach(details -> {
            Date validFromDate = details.validFrom();
            Optional<Schedule> schedule = scheduleContainer.getSchedule(details.region());
            if (schedule.isPresent()) {
                schedule.get().addEntry(new ScheduleEntry(details.region(), details.version(), validFromDate));
            } else {
                Schedule newSchedule = new Schedule(details.profile(), details.region());
                newSchedule.addEntry(new ScheduleEntry(details.region(), details.version(), validFromDate));
                scheduleContainer.add(details.region(), newSchedule);
            }
        });
        return scheduleContainer;
    }

    public SnapshotVersionDao(SnapshotVersionsReader snapshotVersionsDirReader) {
        this.snapshotVersionsDirReader = snapshotVersionsDirReader;
    }
}

