/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.domain;

import io.higson.runtime.core.domain.CacheKey;
import io.higson.runtime.core.domain.DomainCacheManager;
import io.higson.runtime.core.domain.MpDomainCacheProvider;
import io.higson.runtime.core.domain.MpDomainRefreshController;
import io.higson.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.TreeDomain;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDomainCacheManager
implements DomainCacheManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractDomainCacheManager.class);
    protected final MpDomainRefreshController refreshController;
    protected final MpDomainCacheProvider cacheProvider;
    protected Map<String, TreeDomain> headElementsByProfiles = new ConcurrentHashMap<String, TreeDomain>();
    protected Map<CacheKey, TreeDomain> sessionElementsByCacheKey = new ConcurrentHashMap<CacheKey, TreeDomain>();

    public AbstractDomainCacheManager(MpDomainCacheProvider cacheProvider, MpDomainRefreshController refreshController) {
        this.cacheProvider = cacheProvider;
        this.refreshController = refreshController;
    }

    protected abstract void refreshHeads(String var1, EffectiveVersionConfiguration var2);

    @Override
    public Set<String> getProfiles() {
        Set<String> head = this.getProfilesFromHead();
        log.trace("getProfiles() found: {}", head);
        return new HashSet<String>(head);
    }

    Set<String> getProfilesFromHead() {
        return this.headElementsByProfiles.keySet();
    }

    @Override
    public Set<String> getAllProfiles() {
        Set<String> all = this.getHeadAndSessionProfiles();
        log.trace("getAllProfiles() found: {}", all);
        return new HashSet<String>(all);
    }

    Set<String> getHeadAndSessionProfiles() {
        HashSet<String> all = new HashSet<String>();
        for (TreeDomain tree : this.headElementsByProfiles.values()) {
            all.add(tree.getProfile());
        }
        for (TreeDomain tree : this.sessionElementsByCacheKey.values()) {
            all.add(tree.getProfile());
        }
        return all;
    }

    @Override
    public DomainObject getByPath(String profileCode, String path) {
        return this.getByPath(profileCode, path, null);
    }

    @Override
    public DomainObject getByPath(String profileCode, String path, EffectiveVersionConfiguration configuration) {
        log.trace("getting element by path, profileCode:{}, path:{}, effective conf:{})", new Object[]{profileCode, path, configuration});
        if (this.headElementsByProfiles.get(profileCode) == null) {
            this.refreshController.updateTimestampsForProfile(profileCode);
            this.refreshHeads(profileCode, configuration);
        }
        if (this.headElementsByProfiles.get(profileCode) == null) {
            return null;
        }
        return this.headElementsByProfiles.get(profileCode).getObjectsByPath(path);
    }

    protected void refreshSessionsOfProfileAndUser(String profileCode, String user, EffectiveVersionConfiguration configuration) {
        log.trace("enter refreshSessionsOfProfileAndUser({},{},{})", new Object[]{profileCode, user, configuration});
        Map<CacheKey, TreeDomain> trees = this.cacheProvider.createTrees(profileCode, user, configuration);
        if (trees.isEmpty()) {
            this.clearSessions(profileCode);
            return;
        }
        for (Map.Entry<CacheKey, TreeDomain> tree : trees.entrySet()) {
            this.saveReloadedTree(tree);
        }
    }

    private void clearSessions(String profileCode) {
        this.sessionElementsByCacheKey.entrySet().removeIf(session -> this.containsProfileCode(profileCode, (CacheKey)session.getKey()));
    }

    public boolean containsProfileCode(String profileCode, CacheKey entryKey) {
        return entryKey.getProfile().endsWith("@" + profileCode);
    }

    private void saveReloadedTree(Map.Entry<CacheKey, TreeDomain> tree) {
        if (tree.getValue().isAnyRoot()) {
            this.sessionElementsByCacheKey.put(tree.getKey(), tree.getValue());
        } else {
            this.sessionElementsByCacheKey.remove(tree.getKey());
        }
    }

    protected void refreshHeads(String profileCode) {
        this.refreshHeads(profileCode, null);
    }

    @Override
    public DomainObject getSessionElementByPath(String profileCode, String user, String path) {
        return this.getSessionElementByPath(profileCode, user, path, null);
    }

    @Override
    public void invalidateAllCaches() {
        this.headElementsByProfiles.clear();
        this.sessionElementsByCacheKey.clear();
    }
}

