/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.domain;

import io.higson.runtime.cache.UserRegionVersionProvider;
import io.higson.runtime.core.datasource.DomainCacheDao;
import io.higson.runtime.core.domain.AttributeValueProvider;
import io.higson.runtime.core.domain.CacheKey;
import io.higson.runtime.core.domain.SessionIdBuilder;
import io.higson.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import io.higson.runtime.core.versioninterceptor.EffectiveVersionResolver;
import io.higson.runtime.model.DomainAttribute;
import io.higson.runtime.model.DomainAttributeDto;
import io.higson.runtime.model.DomainObjectImpl;
import io.higson.runtime.model.DomainObjectTypeImpl;
import io.higson.runtime.model.DomainTokenResolver;
import io.higson.runtime.model.OpenSession;
import io.higson.runtime.model.ReferenceDto;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.TreeDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpDomainCacheProvider {
    private static final Logger log = LoggerFactory.getLogger(MpDomainCacheProvider.class);
    public static final int NO_SESSION = -1;
    private final DomainCacheDao dao;
    private final EffectiveVersionResolver effectiveVersionResolver;
    private final UserRegionVersionProvider userRegionVersionProvider;
    private AttributeValueProvider valueProvider;

    public MpDomainCacheProvider(DomainCacheDao dao, EffectiveVersionResolver effectiveVersionResolver, UserRegionVersionProvider userRegionVersionProvider) {
        this(dao, effectiveVersionResolver, userRegionVersionProvider, null);
    }

    public MpDomainCacheProvider(DomainCacheDao dao, EffectiveVersionResolver effectiveVersionResolver, UserRegionVersionProvider userRegionVersionProvider, AttributeValueProvider valueProvider) {
        this.dao = dao;
        this.valueProvider = valueProvider;
        this.effectiveVersionResolver = effectiveVersionResolver;
        this.userRegionVersionProvider = userRegionVersionProvider;
    }

    public void setAttributeValueProvider(AttributeValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public TreeDomain createDomainTree(String profileCode, EffectiveVersionConfiguration configuration) {
        return this.createDomainTree(profileCode, configuration, Collections.emptySet());
    }

    public TreeDomain createDomainTree(String profileCode, EffectiveVersionConfiguration configuration, Set<RegionVersion> userVersions) {
        log.trace("creating domain tree for profile:{} using version configuration:{}", (Object)profileCode, (Object)configuration);
        Set<Integer> userRegionVersionIds = this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration, userVersions);
        return this.createTreeFor(profileCode, -1, userRegionVersionIds);
    }

    public TreeDomain createTree(String profile, int sid, Set<Integer> versionIds) {
        return this.createTreeFor(profile, sid, versionIds);
    }

    public Map<CacheKey, TreeDomain> createTrees(String profile, String user, EffectiveVersionConfiguration configuration) {
        log.trace("entering createTrees(profile={},user={}, configuration={})", new Object[]{profile, user, configuration});
        Optional<OpenSession> openSession = this.getOpenSessionForUser(profile, user);
        int sid = openSession.map(OpenSession::getId).orElse(-1);
        if (openSession.isPresent() || StringUtils.isNotBlank((CharSequence)user)) {
            Set<Integer> userRegionVersions = this.getRegionVersionsForUser(profile, user, configuration);
            TreeDomain tree = this.createTreeFor(profile, sid, userRegionVersions);
            CacheKey cacheKey = this.createCacheKeyByVersions(user, profile, userRegionVersions);
            return Map.of(cacheKey, tree);
        }
        return Map.of();
    }

    public CacheKey createCacheKeyByVersions(String userName, String profile, Set<Integer> userRegionVersions) {
        return new CacheKey(SessionIdBuilder.getId(userName, profile), userRegionVersions);
    }

    public CacheKey createCacheKeyByConfiguration(String userName, String profileCode, EffectiveVersionConfiguration configuration) {
        if (configuration != null && configuration.isSnapshotExportConfiguration()) {
            return this.createCacheKeyWithAllProfileRegionVersions(userName, profileCode, configuration);
        }
        Set<Integer> regionVersionsForUser = this.getRegionVersionsForUser(profileCode, userName, configuration);
        return this.createCacheKeyByVersions(userName, profileCode, regionVersionsForUser);
    }

    public Set<Integer> getEffectiveVersionIds(String userName, String profile, EffectiveVersionConfiguration configuration) {
        return this.createCacheKeyByConfiguration(userName, profile, configuration).getVersionIds();
    }

    public Set<Integer> getEffectiveVersionIds(String userName, String profile, EffectiveVersionConfiguration configuration, Set<RegionVersion> userVersions) {
        return this.effectiveVersionResolver.getEffectiveVersionIds(profile, configuration, userVersions);
    }

    private CacheKey createCacheKeyWithAllProfileRegionVersions(String userName, String profileCode, EffectiveVersionConfiguration configuration) {
        Set<Integer> allProfileRegionVersionIds = configuration.getAllRegionVersionsOnlyForSnapshotExport().stream().map(RegionVersion::getId).collect(Collectors.toSet());
        return this.createCacheKeyByVersions(userName, profileCode, allProfileRegionVersionIds);
    }

    public Set<Integer> getRegionVersionsForUser(String profileCode, String user, EffectiveVersionConfiguration configuration) {
        Set<RegionVersion> userVersions = this.userRegionVersionProvider.get(profileCode, user);
        return this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration, userVersions);
    }

    public Optional<OpenSession> getOpenSessionForUser(String profile, String user) {
        return this.dao.getOpenSession(profile, user);
    }

    private TreeDomain createTreeFor(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        log.info("enter createTreeFor, prof={}, sid={}, rvid={}", new Object[]{profileCode, sessionId, userRegionVersions});
        long start = System.currentTimeMillis();
        Map<String, DomainObjectTypeImpl> typesByCodes = this.dao.getTypesByCode(profileCode);
        Map<String, DomainObjectImpl> objectsByIds = this.dao.getObjectsById(profileCode, sessionId, typesByCodes, userRegionVersions);
        Map<String, List<ReferenceDto>> parentReference = this.dao.getReferences(profileCode, sessionId, userRegionVersions);
        Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds = this.dao.getObjectsDynamicAttributesByObjectId(profileCode, sessionId, userRegionVersions);
        Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> attributesByObjectIds = this.dao.getObjectsAttributesByObjectId(profileCode, sessionId, userRegionVersions);
        TreeDomain treeDomain = new TreeDomain(profileCode);
        if (sessionId > 0) {
            treeDomain.addNewParents(this.dao.getNewParents(profileCode, userRegionVersions));
            this.findInconsistency(objectsByIds, treeDomain);
        }
        List<DomainObjectImpl> roots = this.getRootsAndInitOthers(objectsByIds, dynamicAttributesByObjectIds, attributesByObjectIds, treeDomain);
        this.processChildren(roots, objectsByIds, dynamicAttributesByObjectIds, attributesByObjectIds, treeDomain);
        treeDomain.setRoots(roots, typesByCodes, parentReference);
        long time = System.currentTimeMillis() - start;
        log.info("leave createTreeFor, time={}, tree={}", (Object)time, (Object)treeDomain);
        return treeDomain;
    }

    private void findInconsistency(Map<String, DomainObjectImpl> objectsByIds, TreeDomain treeDomain) {
        HashMap<Integer, List<Integer>> parentAndChildren = new HashMap<Integer, List<Integer>>();
        HashSet<Integer> baseElementOpenIsSession = new HashSet<Integer>();
        for (Map.Entry<String, DomainObjectImpl> entry : objectsByIds.entrySet()) {
            if (entry.getValue().getParentId() == null) {
                this.getChildren(parentAndChildren, -1).add(entry.getValue().getId());
            } else {
                this.getChildren(parentAndChildren, entry.getValue().getParentId()).add(entry.getValue().getId());
            }
            if (entry.getValue().isHead() || entry.getValue().getId().equals(entry.getValue().getIdToSelectChildren())) continue;
            baseElementOpenIsSession.add(entry.getValue().getIdToSelectChildren());
        }
        HashMap<String, Integer> duplicateTmpId = new HashMap<String, Integer>();
        for (Map.Entry parent : parentAndChildren.entrySet()) {
            if ((Integer)parent.getKey() != -1 && !baseElementOpenIsSession.contains(parent.getKey()) && !objectsByIds.containsKey(Integer.toString((Integer)parent.getKey()))) {
                for (Integer child : (List)parent.getValue()) {
                    DomainObjectImpl domainObjectImpl = objectsByIds.get(Integer.toString(child));
                    treeDomain.addInconsistency(DomainTokenResolver.resolveFullToken(this.getTypeCollectionCode(domainObjectImpl), domainObjectImpl.getCode()));
                }
            }
            duplicateTmpId.clear();
            for (Integer child : (List)parent.getValue()) {
                DomainObjectImpl domainObjectImpl = objectsByIds.get(Integer.toString(child));
                StringBuilder tmpId = new StringBuilder(DomainTokenResolver.resolveFullToken(this.getTypeCollectionCode(domainObjectImpl), domainObjectImpl.getCode()));
                Integer previous = (Integer)duplicateTmpId.get(tmpId.toString());
                if (previous != null) {
                    DomainObjectImpl elementPrevious = objectsByIds.get(Integer.toString(previous));
                    treeDomain.addDuplicated(tmpId.toString());
                    if (domainObjectImpl.isHead()) {
                        objectsByIds.remove(Integer.toString(domainObjectImpl.getId()));
                    } else if (elementPrevious.isHead()) {
                        objectsByIds.remove(Integer.toString(elementPrevious.getId()));
                    }
                }
                duplicateTmpId.put(tmpId.toString(), domainObjectImpl.getId());
            }
        }
    }

    private String getTypeCollectionCode(DomainObjectImpl element) {
        return element.getTypeCollection().getCode();
    }

    private List<Integer> getChildren(Map<Integer, List<Integer>> parentAndChildren, Integer parentId) {
        return parentAndChildren.computeIfAbsent(parentId, k -> new ArrayList());
    }

    private void processChildren(List<DomainObjectImpl> parents, Map<String, DomainObjectImpl> objectsByIds, Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds, Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> attributesByObjectIds, TreeDomain treeDomain) {
        for (DomainObjectImpl object : parents) {
            String id = Integer.toString(object.getIdToSelectChildren());
            if (this.wasChangedByOtherSession(treeDomain, object)) {
                log.warn("change from: {} to {}", (Object)id, (Object)treeDomain.getNewParentId(object.getCopyFrom()));
                id = treeDomain.getNewParentId(object.getCopyFrom());
                object.setIdToSelectChildren(Integer.valueOf(id));
            }
            ArrayList<DomainObjectImpl> children = new ArrayList<DomainObjectImpl>();
            for (String childId : treeDomain.getChildrenIds(id)) {
                children.add(this.getObjectWithAllAttributes(dynamicAttributesByObjectIds, attributesByObjectIds, objectsByIds.get(childId)));
            }
            if (!Integer.toString(object.getId()).equals(id)) {
                id = Integer.toString(object.getId());
                for (String childId : treeDomain.getChildrenIds(id)) {
                    DomainObjectImpl child = this.getObjectWithAllAttributes(dynamicAttributesByObjectIds, attributesByObjectIds, objectsByIds.get(childId));
                    children.add(child);
                }
            }
            this.processChildren(children, objectsByIds, dynamicAttributesByObjectIds, attributesByObjectIds, treeDomain);
            object.setChildren(children);
        }
    }

    private boolean wasChangedByOtherSession(TreeDomain treeDomain, DomainObjectImpl object) {
        return !object.isHead() && treeDomain.isChangeCopyFrom(object.getCopyFrom());
    }

    private List<DomainObjectImpl> getRootsAndInitOthers(Map<String, DomainObjectImpl> objectsByIds, Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds, Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> attributesByObjectIds, TreeDomain treeDomain) {
        ArrayList<DomainObjectImpl> roots = new ArrayList<DomainObjectImpl>();
        Iterator<Map.Entry<String, DomainObjectImpl>> objectIterator = objectsByIds.entrySet().iterator();
        while (objectIterator.hasNext()) {
            Map.Entry<String, DomainObjectImpl> object = objectIterator.next();
            treeDomain.initObjectIdsAndPath(object.getValue());
            if (!this.isRoot(object.getValue())) continue;
            DomainObjectImpl root = this.getObjectWithAllAttributes(dynamicAttributesByObjectIds, attributesByObjectIds, object.getValue());
            roots.add(root);
            objectIterator.remove();
        }
        return roots;
    }

    private DomainObjectImpl getObjectWithAllAttributes(Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> dynamicAttributesByObjectIds, Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> attributesByObjectIds, DomainObjectImpl object) {
        List<DomainCacheDao.DomainAttributeLoadWrapper> attributeWrappers;
        String id = Integer.toString(object.getId());
        List<DomainCacheDao.DomainAttributeLoadWrapper> dynamicWrappers = dynamicAttributesByObjectIds.get(id);
        if (dynamicWrappers != null) {
            ArrayList<DomainAttribute> dynamicAttributes = new ArrayList<DomainAttribute>(dynamicWrappers.size());
            for (DomainCacheDao.DomainAttributeLoadWrapper wrapper : dynamicWrappers) {
                dynamicAttributes.add(new DomainAttribute(wrapper.getDto(), object, this.valueProvider));
            }
            object.setDynamicAttributes(dynamicAttributes);
        }
        if ((attributeWrappers = attributesByObjectIds.get(id)) != null) {
            ArrayList<DomainAttribute> attributes = new ArrayList<DomainAttribute>(attributeWrappers.size());
            for (DomainCacheDao.DomainAttributeLoadWrapper wrapper : attributeWrappers) {
                DomainAttributeDto attributeDto = wrapper.getDto();
                attributeDto.setDomainType(object.getCollection());
                attributes.add(new DomainAttribute(attributeDto, object, this.valueProvider));
            }
            object.setAttributes(attributes);
        }
        return object;
    }

    private boolean isRoot(DomainObjectImpl object) {
        return object.getParentId() == null;
    }
}

