/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.versioninterceptor;

import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.region.RegionVersionIdentifier;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class EffectiveVersionConfiguration {
    private final Date date;
    private final Set<RegionVersionIdentifier> versionIdentifiers;
    private final boolean snapshotExportConfiguration;
    private final List<RegionVersion> allRegionVersionsOnlyForSnapshotExport;

    public static EffectiveVersionConfiguration withEffectiveVersions(Set<RegionVersionIdentifier> versionIdentifiers) {
        return new EffectiveVersionConfiguration(versionIdentifiers, null, false, List.of());
    }

    public static EffectiveVersionConfiguration withEffectiveDate(Date date) {
        return new EffectiveVersionConfiguration(Set.of(), date, false, List.of());
    }

    public static EffectiveVersionConfiguration withEffectiveVersionsAndDate(Set<RegionVersionIdentifier> versionIdentifiers, Date date) {
        return new EffectiveVersionConfiguration(versionIdentifiers, date, false, List.of());
    }

    public static EffectiveVersionConfiguration configurationForSnapshot(List<RegionVersion> forcedRegionVersions) {
        return new EffectiveVersionConfiguration(Set.of(), null, true, forcedRegionVersions);
    }

    private EffectiveVersionConfiguration(Set<RegionVersionIdentifier> versionIdentifiers, Date date, boolean snapshotExportConfiguration, List<RegionVersion> allRegionVersionsOnlyForSnapshotExport) {
        this.date = date;
        this.versionIdentifiers = versionIdentifiers;
        this.snapshotExportConfiguration = snapshotExportConfiguration;
        this.allRegionVersionsOnlyForSnapshotExport = allRegionVersionsOnlyForSnapshotExport;
    }

    public Optional<Date> getDate() {
        return Optional.ofNullable(this.date);
    }

    public String toString() {
        return "EffectiveVersionConfiguration(date=" + this.getDate() + ", versionIdentifiers=" + this.getVersionIdentifiers() + ", snapshotExportConfiguration=" + this.isSnapshotExportConfiguration() + ", allRegionVersionsOnlyForSnapshotExport=" + this.getAllRegionVersionsOnlyForSnapshotExport() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveVersionConfiguration)) {
            return false;
        }
        EffectiveVersionConfiguration other = (EffectiveVersionConfiguration)o;
        if (this.isSnapshotExportConfiguration() != other.isSnapshotExportConfiguration()) {
            return false;
        }
        Optional<Date> this$date = this.getDate();
        Optional<Date> other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Set<RegionVersionIdentifier> this$versionIdentifiers = this.getVersionIdentifiers();
        Set<RegionVersionIdentifier> other$versionIdentifiers = other.getVersionIdentifiers();
        if (this$versionIdentifiers == null ? other$versionIdentifiers != null : !((Object)this$versionIdentifiers).equals(other$versionIdentifiers)) {
            return false;
        }
        List<RegionVersion> this$allRegionVersionsOnlyForSnapshotExport = this.getAllRegionVersionsOnlyForSnapshotExport();
        List<RegionVersion> other$allRegionVersionsOnlyForSnapshotExport = other.getAllRegionVersionsOnlyForSnapshotExport();
        return !(this$allRegionVersionsOnlyForSnapshotExport == null ? other$allRegionVersionsOnlyForSnapshotExport != null : !((Object)this$allRegionVersionsOnlyForSnapshotExport).equals(other$allRegionVersionsOnlyForSnapshotExport));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSnapshotExportConfiguration() ? 79 : 97);
        Optional<Date> $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Set<RegionVersionIdentifier> $versionIdentifiers = this.getVersionIdentifiers();
        result = result * 59 + ($versionIdentifiers == null ? 43 : ((Object)$versionIdentifiers).hashCode());
        List<RegionVersion> $allRegionVersionsOnlyForSnapshotExport = this.getAllRegionVersionsOnlyForSnapshotExport();
        result = result * 59 + ($allRegionVersionsOnlyForSnapshotExport == null ? 43 : ((Object)$allRegionVersionsOnlyForSnapshotExport).hashCode());
        return result;
    }

    public Set<RegionVersionIdentifier> getVersionIdentifiers() {
        return this.versionIdentifiers;
    }

    public boolean isSnapshotExportConfiguration() {
        return this.snapshotExportConfiguration;
    }

    public List<RegionVersion> getAllRegionVersionsOnlyForSnapshotExport() {
        return this.allRegionVersionsOnlyForSnapshotExport;
    }
}

