/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.dao;

import io.higson.runtime.dao.MiniJdbcTemplate;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.dao.util.RowMapper;
import java.util.List;
import javax.sql.DataSource;

public class BaseDao {
    protected static final int DEFAULT_FETCH_SIZE = 100;
    protected final DataSource dataSource;
    protected final ConnectionInterceptor connectionInterceptor;
    protected MiniJdbcTemplate defaultJdbcTemplate;

    protected BaseDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.dataSource = dataSource;
        this.connectionInterceptor = connectionInterceptor;
        this.defaultJdbcTemplate = new MiniJdbcTemplate(this.dataSource, this.connectionInterceptor);
    }

    protected void setDefaultFetchSize(int defaultFetchSize) {
        this.defaultJdbcTemplate.setFetchSize(defaultFetchSize);
    }

    protected MiniJdbcTemplate jdbcTemplate() {
        return this.defaultJdbcTemplate;
    }

    protected MiniJdbcTemplate jdbcTemplate(int fetchSize) {
        MiniJdbcTemplate jdbcTemplate = new MiniJdbcTemplate(this.dataSource, this.connectionInterceptor);
        jdbcTemplate.setFetchSize(fetchSize);
        return jdbcTemplate;
    }

    protected <T> T getOne(MiniJdbcTemplate jdbcTemplate, String sql, RowMapper<T> mapper) {
        return this.getOne(jdbcTemplate, sql, mapper, null);
    }

    protected <T> T getOne(MiniJdbcTemplate jdbcTemplate, String sql, RowMapper<T> mapper, Object ... args) {
        List<T> list;
        List<T> list2 = list = args == null ? jdbcTemplate.query(sql, mapper) : jdbcTemplate.query(sql, mapper, args);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.isEmpty()) {
            return null;
        }
        throw new RuntimeException("expected one and received: " + list.size());
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDefaultJdbcTemplate(MiniJdbcTemplate defaultJdbcTemplate) {
        this.defaultJdbcTemplate = defaultJdbcTemplate;
    }
}

