/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.dao;

import io.higson.runtime.core.datasource.DomainCacheDao;
import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.dao.BaseDao;
import io.higson.runtime.dao.exception.EmptyResultDaoException;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.dao.util.RowMapper;
import io.higson.runtime.model.AttributeDefinitionImpl;
import io.higson.runtime.model.DomainAttributeDto;
import io.higson.runtime.model.DomainObjectImpl;
import io.higson.runtime.model.DomainObjectTypeImpl;
import io.higson.runtime.model.OpenSession;
import io.higson.runtime.model.ReferenceDto;
import io.higson.runtime.model.RegionCached;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.Tag;
import io.higson.runtime.model.Type;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.DialectTemplate;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainCacheJdbcDao
extends BaseDao
implements DomainCacheDao {
    private static final Logger log = LoggerFactory.getLogger(DomainCacheJdbcDao.class);
    private static final int FETCH_SIZE = 50;
    private static final java.util.Date DATE_1970 = new java.util.Date(0L);
    private static final String COLLECTION_CODE = "collectionCode";
    private static final String COLLECTION_ID = "collectionId";
    private static final String ELEMENT_COPY_FROM = "elementCopyFrom";
    private static final String OBJECT_ID = "objectId";
    private static final String OBJECT_ATTR_ID = "objectAttrId";
    private static final String OBJECT_ATTR_CODE = "objectAttrCode";
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();
    private final VersionDao versionDao;

    public DomainCacheJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor, VersionDao versionDao) {
        super(dataSource, connectionInterceptor);
        this.versionDao = versionDao;
        this.setDefaultFetchSize(50);
    }

    @Override
    public java.util.Date getDomainElementLastUpdate() {
        log.trace("enter get last update");
        java.util.Date date = this.getDate("select max(lastupdate) from @DOMAINELEMENT");
        log.trace("leave get last update, date:{}", (Object)date);
        return date;
    }

    @Override
    public java.util.Date getRegionVersionLastUpdate() {
        log.trace("enter get region version last update");
        java.util.Date date = this.getDate("select max(lastupdate) from @REGIONVERSION");
        log.trace("leave get region version last update, date:{}", (Object)date);
        return date;
    }

    @Override
    public java.util.Date getDomainDefinitionLastUpdate() {
        log.trace("enter get domain definition last update");
        java.util.Date typesDate = this.normalizeDate(this.getDate("select max(modifiedDate) from @DOMAINTYPE"));
        java.util.Date collectionDate = this.normalizeDate(this.getDate("select max(modifiedDate) from @DOMAINTYPECOLLECTION"));
        java.util.Date attributeDate = this.normalizeDate(this.getDate("select max(modifiedDate) from @DOMAINTYPEATTRIBUTE"));
        java.util.Date tmpMax = typesDate.getTime() > collectionDate.getTime() ? typesDate : collectionDate;
        java.util.Date date = tmpMax.getTime() > attributeDate.getTime() ? tmpMax : attributeDate;
        log.trace("leave get domain definition last update, date:{}", (Object)date);
        return date;
    }

    @Override
    public java.util.Date getMaxLastUpdate() {
        String sql = " select max(lastupdate) from @DOMAINELEMENT\n union select max(modifiedDate) from @DOMAINTYPE\n union select max(modifiedDate) from @DOMAINTYPECOLLECTION\n union select max(modifiedDate) from @DOMAINTYPEATTRIBUTE\n";
        List<java.util.Date> lastUpdates = this.jdbcTemplate().query(this.dialect.parse(sql), (rs, i) -> this.normalizeDate(rs.getTimestamp(1)));
        return lastUpdates.stream().max(java.util.Date::compareTo).orElse(DATE_1970);
    }

    private java.util.Date getDate(String s) {
        return this.jdbcTemplate(1).queryForObject(this.dialect.parse(s), java.util.Date.class);
    }

    @Override
    public Map<String, DomainObjectTypeImpl> getTypesByCode(String profileCode) {
        log.trace("enter get types by id for profile:{}", (Object)profileCode);
        HashMap<String, DomainObjectTypeImpl> result = new HashMap<String, DomainObjectTypeImpl>();
        HashMap resultByTypeId = new HashMap();
        String sql = this.dialect.parse(this.createTypeCollectionByProfileCodeQuery().toString());
        this.jdbcTemplate().query(sql, rs -> {
            DomainObjectTypeImpl type = this.createType(rs);
            result.put(Integer.toString(type.getId()), type);
            this.updateResultByTypeId(resultByTypeId, type);
        }, profileCode);
        for (Map.Entry collections : result.entrySet()) {
            DomainObjectTypeImpl collection = (DomainObjectTypeImpl)collections.getValue();
            for (Map.Entry childCollections : result.entrySet()) {
                DomainObjectTypeImpl child = (DomainObjectTypeImpl)childCollections.getValue();
                if (!child.getTypeId().equals(collection.getCollectionType())) continue;
                collection.addChildrenTypes(child);
                child.addParentTypes(collection);
            }
        }
        sql = this.dialect.parse(this.createTypeAttributeByProfileCodeQuery().toString());
        this.jdbcTemplate(100).query(sql, rs -> {
            int typeId = this.dialect.getInt(rs, "typeId");
            AttributeDefinitionImpl attrType = this.createAttributeDefinition(rs);
            List collection = (List)resultByTypeId.get(Integer.toString(typeId));
            if (collection != null) {
                for (DomainObjectTypeImpl coll : collection) {
                    coll.addAttributeDefinition(attrType);
                }
            }
        }, profileCode);
        return result;
    }

    private AttributeDefinitionImpl createAttributeDefinition(ResultSet rs) throws SQLException {
        AttributeDefinitionImpl attrType = new AttributeDefinitionImpl(this.dialect.getString(rs, "attrType"), this.dialect.getString(rs, "attrCode"), this.dialect.getString(rs, "name"), this.dialect.getString(rs, "description"), this.dialect.getString(rs, "groupName"));
        String defaultType = this.dialect.getString(rs, "defaultType");
        if (StringUtils.isNotBlank((CharSequence)defaultType)) {
            attrType.setDefaultType(Type.valueOf(defaultType));
            attrType.setDefaultValue(rs.getString("defaultValue"));
        }
        attrType.setId(rs.getInt("attrId"));
        attrType.setOrder(rs.getInt("attrOrder"));
        attrType.setGroupOrder(rs.getInt("groupOrder"));
        return attrType;
    }

    private StringBuilder createTypeAttributeByProfileCodeQuery() {
        StringBuilder query = new StringBuilder("select dta.$type_id as typeId, dta.$attrtype as attrType, dta.$code as attrCode,");
        query.append(" dta.$name as name, dta.$description as description, dta.$groupname as groupName, dta.groupOrder as groupOrder, dta.$defaultreftype as defaultType, dta.$defaultrefname as defaultValue, dta.id as attrId, dta.attrorder as attrOrder");
        query.append(" from @DOMAINTYPEATTRIBUTE dta");
        query.append(" inner join @domainType dt on dt.id=dta.type_id and dt.archive=0");
        query.append(" where dt.profile_code=?");
        query.append(" and dta.archive=0");
        return query;
    }

    private DomainObjectTypeImpl createType(ResultSet rs) throws SQLException {
        DomainObjectTypeImpl type = new DomainObjectTypeImpl(rs.getInt("id"), this.dialect.getString(rs, COLLECTION_CODE), this.dialect.getString(rs, "collectionName"));
        type.setCollectionType(rs.getInt("collectionType"));
        type.setTypeId(rs.getInt("typeId"));
        type.setTypeCode(rs.getString("typeCode"));
        type.setTypeName(rs.getString("typeName"));
        type.setMultiple(rs.getBoolean("multiple"));
        type.setVisible(rs.getBoolean("visible"));
        type.setRootCollection(rs.getBoolean("rootCollection"));
        type.setParentTypeCode(rs.getString("parentTypeCode"));
        type.setTypeNature(rs.getString("typeNature"));
        type.setOrder(rs.getInt("collOrder"));
        return type;
    }

    private StringBuilder createTypeCollectionByProfileCodeQuery() {
        StringBuilder query = new StringBuilder("select dtc.id as id, dtc.$code as collectionCode, dtc.$name as collectionName, dt.typeNature as typeNature, dtc.type_id as typeId, dt.$code as typeCode, dt.$name as typeName, dtc.collectionType_Id as collectionType, dtc.multiple as multiple, dtc.visible as visible, dtc.collorder as collOrder, dtParent.rootType as rootCollection, dtParent.code as parentTypeCode, dt.typeNature as typeNature");
        query.append(" from @DOMAINTYPECOLLECTION dtc");
        query.append(" join @domainType dt on dt.id=dtc.collectionType_id");
        query.append(" join @domainType dtParent on dtParent.id=dtc.type_id");
        query.append(" where dt.profile_code=?");
        query.append(" and dtc.archive=0");
        query.append(" and dt.archive=0");
        query.append(" and dtParent.archive=0");
        return query;
    }

    @Override
    public Integer getCollectionId(int elementId) {
        log.trace("enter get type by element id:{}", (Object)elementId);
        String query = "select d.collection_id from @DOMAINELEMENT d where d.id =" + elementId;
        String sql = this.dialect.parse(query);
        Integer collectionId = this.jdbcTemplate().queryForObject(sql, Integer.class);
        log.trace("leave get collection id by element id:{}, result:{}", (Object)elementId, (Object)collectionId);
        return collectionId;
    }

    private void updateResultByTypeId(Map<String, List<DomainObjectTypeImpl>> resultByTypeId, DomainObjectTypeImpl type) {
        List<DomainObjectTypeImpl> collectionsList = resultByTypeId.get(Integer.toString(type.getCollectionType()));
        if (collectionsList == null) {
            collectionsList = new ArrayList<DomainObjectTypeImpl>();
        }
        collectionsList.add(type);
        resultByTypeId.put(Integer.toString(type.getCollectionType()), collectionsList);
    }

    @Override
    public Map<String, DomainObjectImpl> getObjectsById(String profileCode, int sessionId, Map<String, DomainObjectTypeImpl> types, Set<Integer> userRegionVersions) {
        log.trace("enter get objects by id for profile:{}", (Object)profileCode);
        StringBuilder query = new StringBuilder("select d.id as objectId, d.$code as objectCode, d.$name as objectName, d.$description as description, d.parent_id as objectParentId");
        query.append(", d.collection_id as collectionId, rv.versionNumber as regionVersion, r.code as regionCode, d.regionVersion_id as versionId");
        query.append(" ,d.$copyfromid as elementCopyFrom, d.$worksessionid as elementWorksessionId, d.head as head");
        query.append(" from @DOMAINELEMENT d");
        query.append(" left join @regionVersion  rv on rv.id=d.regionVersion_id");
        query.append(" left join @region  r on r.id=rv.region_id");
        query.append(" where d.profile_code=?");
        if (sessionId <= 0) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition(" and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        Map<Integer, List<Tag>> domainElementTags = this.getDomainElementTags();
        String sql = this.dialect.parse(query.toString());
        HashMap<String, DomainObjectImpl> result = new HashMap<String, DomainObjectImpl>();
        this.jdbcTemplate(500).query(sql, rs -> {
            int collectionId = rs.getInt(COLLECTION_ID);
            DomainObjectTypeImpl type = (DomainObjectTypeImpl)types.get(Integer.toString(collectionId));
            DomainObjectImpl object = this.getDomainObject(rs, type);
            int elementSessionId = rs.getInt("elementWorksessionId");
            int copyFrom = rs.getInt(ELEMENT_COPY_FROM);
            object.setIdToSelectChildren(this.getCorrectParentId(object.getId(), copyFrom, elementSessionId, sessionId));
            object.setCopyFrom(copyFrom);
            object.setSessionId(elementSessionId);
            object.setRegion(this.getMpRegion(rs));
            object.addAllTags((List)domainElementTags.get(object.getId()));
            result.put("" + object.getId(), object);
        }, profileCode);
        if (log.isTraceEnabled()) {
            log.trace("leave get objects by id for profile:{}, result:{}", (Object)profileCode, result);
        }
        return result;
    }

    private DomainObjectImpl getDomainObject(ResultSet rs, DomainObjectTypeImpl type) throws SQLException {
        return new DomainObjectImpl(rs.getInt(OBJECT_ID), this.dialect.getString(rs, "objectCode"), this.dialect.getString(rs, "objectName"), this.dialect.getString(rs, "description"), type, this.getInteger(rs.getObject("objectParentId")), rs.getBoolean("head"));
    }

    private Map<Integer, List<Tag>> getDomainElementTags() {
        HashMap allTags = new HashMap();
        String parsedQuery = this.dialect.parse("select * from @CATEGORY");
        this.jdbcTemplate().query(parsedQuery, rs -> {
            Tag tag = this.createTag(rs);
            allTags.put(tag.getId(), this.getSingletonListWith(tag));
        });
        HashMap<Integer, List<Tag>> domainElementIdToTagListMap = new HashMap<Integer, List<Tag>>();
        String sql = this.dialect.parse("select domainelements_id, categories_id from @domainelement_category");
        this.jdbcTemplate().query(sql, rs -> {
            int deId = rs.getInt("domainelements_id");
            int cId = rs.getInt("categories_id");
            List tagList = (List)allTags.get(cId);
            domainElementIdToTagListMap.merge(deId, tagList, (val1, val2) -> Stream.of(val1, val2).flatMap(Collection::stream).collect(Collectors.toList()));
        });
        return domainElementIdToTagListMap;
    }

    private Tag createTag(ResultSet rs) throws SQLException {
        return new Tag(rs.getInt("id"), rs.getString("name"), rs.getString("description"), rs.getBoolean("active"), rs.getBoolean("accessControl"));
    }

    private List<Tag> getSingletonListWith(Tag tag) {
        ArrayList<Tag> singletonList = new ArrayList<Tag>();
        singletonList.add(tag);
        return singletonList;
    }

    @Override
    public Map<String, Integer> getNewParents(String profileCode, Set<Integer> userRegionVersions) {
        log.trace("enter getNewParents");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        StringBuilder query = new StringBuilder("select d.id as objectId, d.$copyfromid as elementCopyFrom");
        query.append(" from @DOMAINELEMENT d");
        query.append(" left join @regionVersion  rv on rv.id=d.regionVersion_id");
        query.append(" left join @region  r on r.id=rv.region_id");
        query.append(" where d.profile_code=?");
        query.append(" and d.head=1");
        query.append(" and d.archive=0");
        query.append(" and d.$copyfromid > 0");
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            int objectId = rs.getInt(OBJECT_ID);
            int copyFrom = rs.getInt(ELEMENT_COPY_FROM);
            result.put(Integer.toString(copyFrom), objectId);
            return null;
        }, profileCode);
        return result;
    }

    private void addRegionsCondition(Set<Integer> userRegionVersions, StringBuilder query) {
        if (userRegionVersions.isEmpty()) {
            query.append(" and d.regionversion_id is null");
        } else {
            String userVersionsIds = this.getIdsToIn(userRegionVersions);
            query.append(" and (d.regionversion_id in (");
            query.append(userVersionsIds);
            query.append(" )");
            query.append(" or d.regionversion_id is null)");
        }
    }

    private String getIdsToIn(Set<Integer> userRegionVersions) {
        StringBuilder result = new StringBuilder();
        for (Integer ver : userRegionVersions) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(ver);
        }
        return result.toString();
    }

    private Integer getCorrectParentId(int objectId, int copyFrom, int objectSessionId, int sessionId) {
        if (objectSessionId == sessionId && copyFrom > 0) {
            return copyFrom;
        }
        return objectId;
    }

    private String sessionCondition(String andOrWhere, int sessionId) {
        return " " + andOrWhere + " d.archive = 0 and ((d.head = 0 and d.workSessionId = " + sessionId + ") or (d.head = 1  and not exists (select de2.id from @domainElement de2 where de2.copyFromId=d.id and de2.workSessionId=" + sessionId + ") ) )";
    }

    @Override
    public Map<String, List<ReferenceDto>> getReferences(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        log.trace("enter getReferences({})", (Object)profileCode);
        StringBuilder query = new StringBuilder("select dr.parent_id as parentId, dr.$elementPath as path, dr.collection_id as collectionId, dtc.code as collectionCode");
        query.append(" from @DOMAINELEMENT d");
        query.append(" join @domainReference  dr on dr.parent_id=d.id");
        query.append(" join @domainTypeCollection  dtc on dtc.id=dr.collection_id");
        query.append(" where d.profile_code=?");
        query.append(" and dtc.archive=0");
        if (sessionId <= 0) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition(" and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        HashMap<String, List<ReferenceDto>> result = new HashMap<String, List<ReferenceDto>>();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            int parentId = this.dialect.getInt(rs, "parentId");
            ArrayList<ReferenceDto> paths = (ArrayList<ReferenceDto>)result.get(Integer.toString(parentId));
            if (paths == null) {
                paths = new ArrayList<ReferenceDto>();
            }
            paths.add(new ReferenceDto(this.dialect.getString(rs, "path"), this.dialect.getInt(rs, COLLECTION_ID), this.dialect.getString(rs, COLLECTION_CODE)));
            result.put(Integer.toString(parentId), paths);
            return null;
        }, profileCode);
        return result;
    }

    @Override
    public List<ReferenceDto> getReferences(int elementId) {
        log.trace("enter getReferences({})", (Object)elementId);
        String query = "select dr.parent_id as parentId, dr.$elementPath as path, dr.collection_id as collectionId, dtc.code as collectionCode from @DOMAINELEMENT d join @domainReference  dr on dr.parent_id=d.id join @domainTypeCollection  dtc on dtc.id=dr.collection_id where d.id=?";
        String sql = this.dialect.parse(query);
        ArrayList<ReferenceDto> result = new ArrayList<ReferenceDto>();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            this.dialect.getInt(rs, "parentId");
            result.add(new ReferenceDto(this.dialect.getString(rs, "path"), this.dialect.getInt(rs, COLLECTION_ID), this.dialect.getString(rs, COLLECTION_CODE)));
            return null;
        }, elementId);
        return result;
    }

    @Override
    public Map<String, java.util.Date> getProfileLastUpdates() {
        log.trace("enter getProfileLastUpdates()");
        HashMap<String, java.util.Date> result = new HashMap<String, java.util.Date>();
        StringBuilder query = new StringBuilder("select d.profile_code as profile, max(d.lastupdate) as lastupdate");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" where d.profile_code is not null");
        query.append(" group by d.profile_code");
        String sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, (rs, i) -> {
            java.util.Date lastUpdate = this.toDate(this.dialect.getTimestamp(rs, "lastupdate"));
            String profile = this.dialect.getString(rs, "profile");
            result.put(profile, lastUpdate);
            return null;
        });
        query = new StringBuilder("select d.profile_code as profile, max(d.modifieddate) as lastupdate");
        query.append(" from @DOMAINTYPE  d");
        query.append(" where d.profile_code is not null");
        query.append(" group by d.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        query = new StringBuilder("select dt.profile_code as profile, max(dtc.modifieddate) as lastupdate");
        query.append(" from @DOMAINTYPECOLLECTION  dtc");
        query.append(" inner join @domainType dt on dt.id = dtc.type_id");
        query.append(" where dt.profile_code is not null");
        query.append(" group by dt.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        query = new StringBuilder("select dt.profile_code as profile, max(dta.modifieddate) as lastupdate");
        query.append(" from @DOMAINTYPEATTRIBUTE  dta");
        query.append(" inner join @domainType dt on dt.id = dta.type_id");
        query.append(" where dt.profile_code is not null");
        query.append(" group by dt.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        query = new StringBuilder("select r.profile_code as profile, max(rv.lastupdate) as lastupdate");
        query.append(" from @regionversion rv");
        query.append(" inner join @region r on r.id = rv.region_id");
        query.append(" where r.profile_code is not null");
        query.append(" group by r.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        return result;
    }

    @Override
    public Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> getObjectsDynamicAttributesByObjectId(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        log.trace("enter getObjectsDynamicAttributesByObjectId({})", (Object)profileCode);
        StringBuilder query = new StringBuilder("select deea.id as objectAttrId, deea.$code as objectAttrCode, deea.$name as objectAttrName, deea.$description as objectAttrDescription, deea.attrType as objectAttrType, deea.attrValue as objectAttrValue, deea.refType as objectRefType, deea.domainElement_Id as objectId");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" inner join @domainElementExtraAttr  deea on deea.domainElement_id=d.id");
        query.append(" where d.profile_code=?");
        if (sessionId <= 0) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition("and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        HashMap<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> result = new HashMap<String, List<DomainCacheDao.DomainAttributeLoadWrapper>>();
        this.jdbcTemplate(100).query(sql, rs -> {
            DomainAttributeDto attribute = new DomainAttributeDto(rs.getInt(OBJECT_ATTR_ID), rs.getInt(OBJECT_ID), this.dialect.getString(rs, OBJECT_ATTR_CODE));
            attribute.setName(this.dialect.getString(rs, "objectAttrName"));
            attribute.setDescription(this.dialect.getString(rs, "objectAttrDescription"));
            attribute.setType(this.dialect.getString(rs, "objectAttrType"));
            attribute.setRawValue(this.dialect.getString(rs, "objectAttrValue"));
            String objectRefType = this.dialect.getString(rs, "objectRefType");
            attribute.setRawType(objectRefType == null ? Type.LITERAL : Type.valueOf(objectRefType));
            String id = Integer.toString(attribute.getDomainObjectId());
            result.put(id, this.addToList(result, attribute, id));
        }, profileCode);
        return result;
    }

    @Override
    public Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> getObjectsAttributesByObjectId(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        log.trace("enter getObjectsAttributesByObjectId({})", (Object)profileCode);
        StringBuilder query = new StringBuilder("select dea.id as objectAttrId, dta.$code as objectAttrCode, dta.$name as objectAttrDesc, dta.$description as objectAttrDescription, dea.refname as objectAttrRefName, dea.refType as objectAttrRefType, dea.TYPEATTRIBUTE_ID as typeId, dea.domainElement_id as objectId");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" inner join @domainElementAttribute  dea on dea.domainElement_Id=d.id");
        query.append(" inner join @domainTypeAttribute  dta on dta.id=dea.TYPEATTRIBUTE_ID  and dta.archive=0");
        query.append(" where d.profile_code=?");
        if (sessionId <= 0) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition("and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        HashMap<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> result = new HashMap<String, List<DomainCacheDao.DomainAttributeLoadWrapper>>();
        this.jdbcTemplate(500).query(sql, rs -> {
            int idTmp = rs.getInt(OBJECT_ID);
            DomainAttributeDto attribute = new DomainAttributeDto(rs.getInt(OBJECT_ATTR_ID), idTmp, rs.getString(OBJECT_ATTR_CODE));
            attribute.setName(rs.getString("objectAttrDesc"));
            attribute.setDescription(rs.getString("objectAttrDescription"));
            attribute.setRawValue(rs.getString("objectAttrRefName"));
            attribute.setRawType(Type.valueOf(rs.getString("objectAttrRefType")));
            result.put(Integer.toString(idTmp), this.addToList(result, attribute, Integer.toString(idTmp)));
        }, profileCode);
        return result;
    }

    private Integer getInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    @Override
    public List<RegionVersion> getUserVersions(String profileCode, String user) {
        return this.versionDao.getUserRegionVersions(profileCode, user);
    }

    @Override
    public Optional<OpenSession> getOpenSession(String profile, String user) {
        log.trace("enter getOpenSessions({},{})", (Object)profile, (Object)user);
        String sql = this.dialect.parse(" select ws.id as id from @worksession  ws  where ws.status = ?   and ws.username = ?   and ws.remotesession = 0");
        OpenSession session = null;
        try {
            Integer sid = this.jdbcTemplate().queryForObject(sql, Integer.class, "OPEN", user);
            if (sid != null) {
                sql = this.dialect.parse("select max(d.id) as id from @DOMAINELEMENT d  where d.worksessionid = ?   and d.profile_code = ?   and d.head = 0");
                Integer elId = this.jdbcTemplate().queryForObject(sql, Integer.class, sid, profile);
                if (elId != null) {
                    session = new OpenSession(sid, user);
                }
            }
        }
        catch (EmptyResultDaoException e) {
            log.trace("no open session");
        }
        return Optional.ofNullable(session);
    }

    @Override
    public java.util.Date getLastUpdateForProfile(String profileCode) {
        log.trace("enter getLastUpdateForProfile({})", (Object)profileCode);
        return this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse("select max(lastupdate) from @DOMAINELEMENT where profile_code=? and head=1"), java.util.Date.class, profileCode));
    }

    @Override
    public java.util.Date getLastUpdateForOpenSession(String profileCode, String user) {
        log.trace("enter getLastUpdateForOpenSession({},{})", (Object)profileCode, (Object)user);
        String query = " select max(lastupdate) from @DOMAINELEMENT where profile_code = ?    and worksessionid in (select id from @worksession where $username=? and status = 'OPEN') ";
        String sql = this.dialect.parse(query);
        return this.normalizeDate(this.jdbcTemplate().queryForObject(sql, java.util.Date.class, profileCode, user));
    }

    @Override
    public java.util.Date getDefinitionLastUpdateInProfile(String profileCode) {
        java.util.Date typesDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse("select max(modifiedDate) from @DOMAINTYPE where profile_code=?"), java.util.Date.class, profileCode));
        java.util.Date collectionDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse(" select max(dtc.modifiedDate) from @DOMAINTYPECOLLECTION dtc where dtc.type_id in (select dt.id from @DOMAINTYPE dt where dt.profile_code=?)"), java.util.Date.class, profileCode));
        java.util.Date attributeDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse(" select max(dta.modifiedDate) from @DOMAINTYPEATTRIBUTE dta join @DOMAINTYPE dt on dt.id=dta.type_id where dt.profile_code=?"), java.util.Date.class, profileCode));
        java.util.Date tmpMax = typesDate.getTime() > collectionDate.getTime() ? typesDate : collectionDate;
        tmpMax = tmpMax.getTime() > attributeDate.getTime() ? tmpMax : attributeDate;
        return tmpMax;
    }

    private java.util.Date normalizeDate(java.util.Date date) {
        return date != null ? new java.util.Date(date.getTime()) : DATE_1970;
    }

    private RegionCached getMpRegion(ResultSet rs) throws SQLException {
        String regionCode = rs.getString("regionCode");
        RegionCached region = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{regionCode}) ? new RegionCached(regionCode, rs.getString("regionVersion"), rs.getInt("versionId")) : new RegionCached();
        return region;
    }

    private List<DomainCacheDao.DomainAttributeLoadWrapper> addToList(Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> result, DomainAttributeDto attribute, String id) {
        List<DomainCacheDao.DomainAttributeLoadWrapper> attrList = result.get(id);
        if (attrList == null) {
            attrList = new ArrayList<DomainCacheDao.DomainAttributeLoadWrapper>();
        }
        attrList.add(new DomainCacheDao.DomainAttributeLoadWrapper(attribute));
        return attrList;
    }

    private java.util.Date toDate(Date date) {
        return new java.util.Date(date.getTime());
    }

    private final class MaxDateRowMapper
    implements RowMapper<Object> {
        private final Map<String, java.util.Date> result;

        @Override
        public Object mapRow(ResultSet rs, int i) throws SQLException {
            java.util.Date lastUpdate = DomainCacheJdbcDao.this.toDate(DomainCacheJdbcDao.this.dialect.getTimestamp(rs, "lastupdate"));
            String profile = DomainCacheJdbcDao.this.dialect.getString(rs, "profile");
            java.util.Date current = this.result.get(profile);
            if (current != null && lastUpdate.after(current)) {
                this.result.put(profile, lastUpdate);
            }
            return null;
        }

        public MaxDateRowMapper(Map<String, java.util.Date> result) {
            this.result = result;
        }
    }
}

