/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.cache;

import io.higson.runtime.engine.cache.MapCache;
import io.higson.runtime.engine.core.prepared.PreparedParamCache;
import io.higson.runtime.engine.core.prepared.PreparedParameter;
import io.higson.runtime.model.Parameter;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPreparedParamCache
extends MapCache<PreparedParameter>
implements PreparedParamCache {
    private static final Logger log = LoggerFactory.getLogger(MapPreparedParamCache.class);

    @Override
    public void invalidate(int pid) {
        Iterator it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            PreparedParameter pp = (PreparedParameter)entry.getValue();
            Parameter p = (Parameter)pp.getMetadata();
            if (pp.getId() == pid) {
                log.debug("removing pp by pid: {}", (Object)pp);
                it.remove();
                p.close();
                continue;
            }
            if (p == null || !p.isSlave() || p.getMid() != pid) continue;
            log.debug("removing pp by mid: {}", (Object)pp);
            it.remove();
            p.close();
        }
    }

    @Override
    public void invalidate() {
        this.cache.values().forEach(pp -> {
            Parameter p = (Parameter)pp.getMetadata();
            p.close();
        });
        super.invalidate();
    }
}

