/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.prepared;

import io.higson.runtime.engine.core.index.LevelIndex;
import io.higson.runtime.engine.core.parameter.Parameter;
import io.higson.runtime.engine.core.prepared.PreparedLevel;
import io.higson.runtime.evict.IdleChecker;
import io.higson.runtime.evict.NopIdleChecker;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedParameter {
    private static final Logger log = LoggerFactory.getLogger(PreparedParameter.class);
    private final int id;
    private final String name;
    private final PreparedLevel[] levels;
    private LevelIndex<String[]> index;
    private final int inputLevelsCount;
    private final boolean nullable;
    private final boolean cacheable;
    private final boolean aiModelSource;
    private final char arraySeparator;
    private final boolean dictionary;
    private Map<String, Integer> levelNameMap = new HashMap<String, Integer>();
    private Object metadata;
    private final IdleChecker idleChecker;
    private volatile long lastAccess;

    public PreparedParameter(Parameter parameter, PreparedLevel[] levels, IdleChecker idleChecker) {
        this.id = parameter.getId();
        this.name = parameter.getName();
        this.inputLevelsCount = parameter.getInputLevels();
        this.nullable = parameter.isNullable();
        this.dictionary = parameter.isDictionary();
        this.cacheable = parameter.isCacheable();
        this.aiModelSource = parameter.isAiModelSource();
        this.arraySeparator = parameter.getArraySeparator();
        this.levels = levels;
        this.idleChecker = idleChecker;
        this.lastAccess = idleChecker.clockTime();
    }

    public PreparedParameter(Parameter parameter, PreparedLevel[] levels) {
        this(parameter, levels, NopIdleChecker.getInstance());
    }

    public int getLevelCount() {
        return this.levels != null ? this.levels.length : 0;
    }

    public boolean isNotNull() {
        return !this.isNullable();
    }

    public void setLevelNameMap(Map<String, Integer> levelNameMap) {
        this.levelNameMap = Map.copyOf(levelNameMap);
    }

    public void resetLastAccessTime() {
        this.lastAccess = this.idleChecker.clockTime();
    }

    public boolean isIdleTimeExceeded() {
        return this.idleChecker.idleTimeExceeded(this);
    }

    private int getOutputLevelsCount() {
        return this.getLevelCount() - this.getInputLevelsCount();
    }

    public String toString() {
        return "PP#" + this.id + "[" + this.name + ", levels=" + this.getInputLevelsCount() + "/" + this.getOutputLevelsCount() + (this.nullable ? ", nullable" : ", notnull") + (this.cacheable ? ", in-mem" : ", no-mem") + (this.aiModelSource ? ", ai-model-source" : "") + (this.dictionary ? ", is dictionary" : "") + "]";
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PreparedLevel[] getLevels() {
        return this.levels;
    }

    public LevelIndex<String[]> getIndex() {
        return this.index;
    }

    public int getInputLevelsCount() {
        return this.inputLevelsCount;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isAiModelSource() {
        return this.aiModelSource;
    }

    public char getArraySeparator() {
        return this.arraySeparator;
    }

    public boolean isDictionary() {
        return this.dictionary;
    }

    public Map<String, Integer> getLevelNameMap() {
        return this.levelNameMap;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public IdleChecker getIdleChecker() {
        return this.idleChecker;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setIndex(LevelIndex<String[]> index) {
        this.index = index;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }
}

