/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow;

import io.higson.runtime.flow.dto.SourceType;
import jakarta.annotation.Nullable;

public class ActionArgument {
    private Object value;
    private SourceType sourceType;
    @Nullable
    private String name;

    ActionArgument(Object value, SourceType sourceType, @Nullable String name) {
        this.value = value;
        this.sourceType = sourceType;
        this.name = name;
    }

    public static ActionArgumentBuilder builder() {
        return new ActionArgumentBuilder();
    }

    public Object getValue() {
        return this.value;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public static class ActionArgumentBuilder {
        private Object value;
        private SourceType sourceType;
        private String name;

        ActionArgumentBuilder() {
        }

        public ActionArgumentBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public ActionArgumentBuilder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public ActionArgumentBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public ActionArgument build() {
            return new ActionArgument(this.value, this.sourceType, this.name);
        }

        public String toString() {
            return "ActionArgument.ActionArgumentBuilder(value=" + this.value + ", sourceType=" + this.sourceType + ", name=" + this.name + ")";
        }
    }
}

