/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow;

import io.higson.runtime.flow.Condition;
import io.higson.runtime.flow.dto.ConditionInputType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;

public class ConditionFactory {
    public static String create(List<Condition> conditions) {
        Validate.notEmpty(conditions, (String)"List of conditions cannot be empty", (Object[])new Object[0]);
        String firstCondition = ConditionFactory.createCondition(conditions.get(0));
        if (conditions.size() == 1) {
            return firstCondition;
        }
        return firstCondition + conditions.stream().skip(1L).map(cond -> " " + cond.getJoinConditionOperator().getValue() + " " + ConditionFactory.createCondition(cond)).collect(Collectors.joining());
    }

    private static String createCondition(Condition condition) {
        Object left = ConditionFactory.getPart(condition.getLeftInputType(), condition.getLeftInputValue());
        Object right = ConditionFactory.getPart(condition.getRightInputType(), condition.getRightInputValue());
        return left + condition.getOperator().getValue() + right;
    }

    private static Object getPart(ConditionInputType type, Object value) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ConditionInputType.ARGUMENT, ConditionInputType.VARIABLE -> value;
            case ConditionInputType.LITERAL -> {
                if (ConditionFactory.isLiteralStringValue(value)) {
                    yield ConditionFactory.wrapInQuotationMarksIfAbsent(value);
                }
                yield value;
            }
            case ConditionInputType.CTX -> ConditionFactory.wrapInGetContextValue(value);
        };
    }

    private static boolean isLiteralStringValue(Object value) {
        String s;
        return value instanceof String && !ConditionFactory.doesStringContainNumber(s = (String)value) && !ConditionFactory.doesStringContainBoolean(s);
    }

    private static boolean doesStringContainNumber(String s) {
        return NumberUtils.isCreatable((String)s);
    }

    private static boolean doesStringContainBoolean(String s) {
        return "true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s);
    }

    private static String wrapInGetContextValue(Object value) {
        return "ctx.get(" + ConditionFactory.wrapInQuotationMarksIfAbsent(value) + ")";
    }

    private static String wrapInQuotationMarksIfAbsent(Object value) {
        return StringUtils.wrapIfMissing((String)String.valueOf(value), (String)"'");
    }
}

