/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow;

import io.higson.runtime.flow.Node;
import io.higson.runtime.flow.Variable;
import io.higson.runtime.function.groovy.shell.CompiledGroovyFunction;
import io.higson.runtime.function.groovy.shell.GroovyCache;
import io.higson.runtime.model.GroovyFunction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Flow
implements GroovyCache {
    private List<String> arguments;
    private List<Variable> variables;
    private List<Node> nodes;
    private String startNodeId;
    private final Map<String, CompiledGroovyFunction> functions = new ConcurrentHashMap<String, CompiledGroovyFunction>();

    public Flow(List<String> arguments, List<Variable> variables, List<Node> nodes, String startNodeId) {
        this.arguments = arguments;
        this.variables = variables;
        this.nodes = nodes;
        this.startNodeId = startNodeId;
    }

    public List<String> getArguments() {
        return this.arguments != null ? this.arguments : Collections.emptyList();
    }

    public List<Variable> getVariables() {
        return this.variables != null ? this.variables : Collections.emptyList();
    }

    public List<Node> getNodes() {
        return this.nodes != null ? this.nodes : Collections.emptyList();
    }

    @Override
    public CompiledGroovyFunction get(GroovyFunction key) {
        return this.functions.get(key.getBody());
    }

    @Override
    public void put(GroovyFunction key, CompiledGroovyFunction function) {
        this.functions.put(key.getBody(), function);
    }

    public static FlowBuilder builder() {
        return new FlowBuilder();
    }

    public String getStartNodeId() {
        return this.startNodeId;
    }

    public Map<String, CompiledGroovyFunction> getFunctions() {
        return this.functions;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setStartNodeId(String startNodeId) {
        this.startNodeId = startNodeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$arguments = this.getArguments();
        List<String> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        List<Variable> this$variables = this.getVariables();
        List<Variable> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        List<Node> this$nodes = this.getNodes();
        List<Node> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        String this$startNodeId = this.getStartNodeId();
        String other$startNodeId = other.getStartNodeId();
        if (this$startNodeId == null ? other$startNodeId != null : !this$startNodeId.equals(other$startNodeId)) {
            return false;
        }
        Map<String, CompiledGroovyFunction> this$functions = this.getFunctions();
        Map<String, CompiledGroovyFunction> other$functions = other.getFunctions();
        return !(this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        List<Variable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        List<Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        String $startNodeId = this.getStartNodeId();
        result = result * 59 + ($startNodeId == null ? 43 : $startNodeId.hashCode());
        Map<String, CompiledGroovyFunction> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        return result;
    }

    public String toString() {
        return "Flow(arguments=" + this.getArguments() + ", variables=" + this.getVariables() + ", nodes=" + this.getNodes() + ", startNodeId=" + this.getStartNodeId() + ", functions=" + this.getFunctions() + ")";
    }

    public static class FlowBuilder {
        private List<String> arguments;
        private List<Variable> variables;
        private List<Node> nodes;
        private String startNodeId;

        FlowBuilder() {
        }

        public FlowBuilder arguments(List<String> arguments) {
            this.arguments = arguments;
            return this;
        }

        public FlowBuilder variables(List<Variable> variables) {
            this.variables = variables;
            return this;
        }

        public FlowBuilder nodes(List<Node> nodes) {
            this.nodes = nodes;
            return this;
        }

        public FlowBuilder startNodeId(String startNodeId) {
            this.startNodeId = startNodeId;
            return this;
        }

        public Flow build() {
            return new Flow(this.arguments, this.variables, this.nodes, this.startNodeId);
        }

        public String toString() {
            return "Flow.FlowBuilder(arguments=" + this.arguments + ", variables=" + this.variables + ", nodes=" + this.nodes + ", startNodeId=" + this.startNodeId + ")";
        }
    }
}

