/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow;

import io.higson.runtime.core.AdhocContext;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.decoder.CascadeDecoder;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.flow.Action;
import io.higson.runtime.flow.ActionArgument;
import io.higson.runtime.flow.ActionType;
import io.higson.runtime.flow.ConditionFactory;
import io.higson.runtime.flow.Flow;
import io.higson.runtime.flow.FlowResult;
import io.higson.runtime.flow.Link;
import io.higson.runtime.flow.Node;
import io.higson.runtime.flow.Variable;
import io.higson.runtime.flow.dto.SourceType;
import io.higson.runtime.flow.trace.ActionExecutedEvent;
import io.higson.runtime.flow.trace.ConditionEvaluatedEvent;
import io.higson.runtime.flow.trace.EnterNodeEvent;
import io.higson.runtime.flow.trace.LeaveNodeEvent;
import io.higson.runtime.flow.trace.TransitionEvent;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.invoker.GroovyFunctionInvoker;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.model.GroovyFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowExecutor {
    private static final Logger log = LoggerFactory.getLogger(FlowExecutor.class);
    private final GroovyFunctionInvoker invoker;
    private final HigsonEngine engine;
    private final CascadeDecoder decoder;
    private final Flow flow;
    private final String flowName;
    private final HigsonContext ctx;
    private final Map<String, Node> nodes;
    private final Map<String, Variable> variables;
    private final Map<String, Object> arguments;
    private Node currentNode;
    private final FlowResult result = new FlowResult();
    private static final AtomicInteger conditionId = new AtomicInteger(0);
    private static final TypeConverter converter = TypeConverter.getInstance();
    private static final char DOMAIN_META_SEPARATOR = ':';

    public FlowExecutor(HigsonEngine engine, GroovyFunctionInvoker invoker, Flow flow, String flowName, Object[] args) {
        this.engine = engine;
        this.decoder = new CascadeDecoder(engine);
        this.invoker = invoker;
        this.flow = flow;
        this.flowName = flowName;
        this.ctx = FlowExecutor.getContext(args);
        this.arguments = this.getArguments(args);
        this.nodes = FlowExecutor.mapNodes(flow);
        this.variables = FlowExecutor.mapVariables(flow);
    }

    public FlowResult execute() {
        log.info("start executing flow with nodes: {}", this.nodes.keySet());
        Node node = this.nodes.get(this.flow.getStartNodeId());
        while (node != null) {
            Node target = this.execNode(node);
            log.info("transition from {} to {}", (Object)this.flow.getStartNodeId(), (Object)target);
            node = target;
        }
        this.result.setResult(this.variables.entrySet().stream().filter(v -> ((Variable)v.getValue()).isReturned()).filter(v -> ((Variable)v.getValue()).getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Variable)e.getValue()).getValue())));
        return this.result;
    }

    private static Map<String, Variable> mapVariables(Flow flow) {
        return flow.getVariables().stream().collect(Collectors.toMap(Variable::getName, Function.identity()));
    }

    private static Map<String, Node> mapNodes(Flow flow) {
        return flow.getNodes().stream().collect(Collectors.toMap(Node::getId, Function.identity()));
    }

    private Map<String, Object> getArguments(Object[] args) {
        return args != null && args.length > 1 ? this.buildArgs(args) : Collections.emptyMap();
    }

    private static HigsonContext getContext(Object[] args) {
        return args != null && args[0] instanceof HigsonContext ? (HigsonContext)args[0] : new HigsonContext(new Object[0]);
    }

    private Node execNode(Node node) {
        log.info("executing node {}", (Object)node);
        this.currentNode = node;
        this.result.addEvent(new EnterNodeEvent(this.flowName, node.getId(), this.getVarSnapshot()));
        for (Action action : node.getActions()) {
            this.execAction(action);
        }
        for (Variable var : this.variables.values()) {
            log.info("  {} = {}   ({})", new Object[]{this.pad(var.getName(), 15), this.pad("" + var.getValue(), 10), var.getType()});
        }
        this.result.addEvent(new LeaveNodeEvent(this.flowName, this.currentNode.getId(), this.getVarSnapshot()));
        for (Link link : node.getLinks()) {
            String condition = this.getCondition(link);
            boolean passed = this.checkCondition(node, condition);
            this.result.addEvent(new ConditionEvaluatedEvent(this.flowName, this.currentNode.getId(), condition, passed));
            if (!passed) continue;
            this.result.addEvent(new TransitionEvent(this.flowName, node.getId(), link.getTarget(), condition));
            return this.nodes.get(link.getTarget());
        }
        return this.nodes.get(this.currentNode.getDefaultNextNode());
    }

    private String getCondition(Link link) {
        return link.getConditionString() != null ? link.getConditionString() : ConditionFactory.create(link.getCondition());
    }

    private void execAction(Action action) {
        Variable var = this.getVar(action.getOutputVariable());
        Object value = switch (action.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ActionType.DECISION_TABLE -> this.getDecisionTableValue(action, var.getType());
            case ActionType.FUNCTION -> this.engine.call(action.getValue(), this.ctx, this.getActionArgs(action));
            case ActionType.FLOW -> this.engine.flow(action.getValue(), this.ctx, this.getActionArgs(action));
            case ActionType.DOMAIN -> this.getDomain(action.getValue(), var.getType(), this.ctx);
            case ActionType.EXPRESSION -> this.evalExpr(this.currentNode, action.getValue());
        };
        var.setValue(value);
        if (action.getType() == ActionType.FLOW) {
            this.result.addEvents(((FlowResult)value).getTrace().getEvents());
        }
        this.result.addEvent(new ActionExecutedEvent(this.flowName, this.currentNode.getId(), action, value, this.getVarSnapshot()));
    }

    private Object getDecisionTableValue(Action action, String type) {
        if (action.getValue().contains("[")) {
            return this.decoder.cascadeGet(action.getValue(), TypeConverter.getInstance().getType(type), this.overrideCtx(this.ctx, action.getArguments()));
        }
        ParamValue value = this.engine.get(action.getValue(), this.overrideCtx(this.ctx, action.getArguments()));
        return FlowExecutor.isOneValue(value) ? value.row(0).get(0) : value;
    }

    private static boolean isOneValue(ParamValue value) {
        return value.rows().size() == 1 && value.row(0).size() == 1;
    }

    private Object getDomain(String value, String type, HigsonContext ctx) {
        DomainMeta domainMeta = new DomainMeta(value);
        DomainObject domain = this.engine.getDomain(domainMeta.profile, domainMeta.path);
        return switch (type) {
            case "integer" -> domain.getAttrInteger(domainMeta.attribute, ctx);
            case "boolean" -> domain.getAttrBoolean(domainMeta.attribute, ctx);
            case "decimal" -> domain.getAttrDecimal(domainMeta.attribute, ctx);
            case "date" -> domain.getAttrDate(domainMeta.attribute, ctx);
            case "object" -> domain.getAttribute(domainMeta.attribute).getValue(ctx, new Object[0]).get();
            default -> domain.getAttrString(domainMeta.attribute, ctx);
        };
    }

    private Object[] getActionArgs(Action action) {
        return action.getArguments().stream().map(this::getArgumentValue).toArray();
    }

    private Map<String, Object> buildArgs(Object[] argsValues) {
        if (argsValues == null || argsValues.length == 1) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> flowArguments = new HashMap<String, Object>();
        int i = 1;
        Iterator<String> iterator = this.flow.getArguments().iterator();
        while (iterator.hasNext() && i < argsValues.length) {
            String next = iterator.next();
            flowArguments.put(next, argsValues[i++]);
        }
        return flowArguments;
    }

    private Object getArgumentValue(ActionArgument argument) {
        return switch (argument.getSourceType()) {
            default -> throw new IncompatibleClassChangeError();
            case SourceType.LITERAL -> argument.getValue();
            case SourceType.INPUT -> this.getArg(argument.getValue().toString());
            case SourceType.VARIABLE -> this.getVar(argument.getValue().toString()).getValue();
        };
    }

    private boolean checkCondition(Node node, String condition) {
        if (StringUtils.isEmpty((CharSequence)condition) || condition.equals("else")) {
            log.info("condition [{}] result: {}", (Object)condition, (Object)true);
            return true;
        }
        int tempFunId = conditionId.decrementAndGet();
        String funCode = "condition_" + node.getId() + tempFunId;
        GroovyFunction fun = new GroovyFunction(tempFunId, tempFunId, funCode, this.createArgsPrototype(), condition);
        Object obj = this.invoker.invoke((io.higson.runtime.engine.core.function.Function)fun, this.flow, this.createArgsValues());
        boolean result = converter.getBoolean(obj);
        log.info("condition [{}] result: {}", (Object)condition, (Object)result);
        return result;
    }

    private Object evalExpr(Node node, String expr) {
        int tempFunId = conditionId.decrementAndGet();
        String funCode = "expr_" + node.getId() + tempFunId;
        GroovyFunction fun = new GroovyFunction(tempFunId, tempFunId, funCode, this.createArgsPrototype(), expr);
        return this.invoker.invoke((io.higson.runtime.engine.core.function.Function)fun, this.flow, this.createArgsValues());
    }

    private String createArgsPrototype() {
        StringBuilder buf = new StringBuilder("ctx");
        for (Variable var : this.variables.values()) {
            buf.append(',').append(var.getName());
        }
        for (String arg : this.arguments.keySet()) {
            buf.append(',').append(arg);
        }
        return buf.toString();
    }

    private Object[] createArgsValues() {
        Object[] args = new Object[this.variables.size() + this.arguments.size() + 1];
        args[0] = this.ctx;
        int i = 0;
        for (Variable var : this.variables.values()) {
            args[++i] = var.getValue();
        }
        for (Object arg : this.arguments.values()) {
            args[++i] = arg;
        }
        return args;
    }

    private Variable getVar(String varName) {
        return this.variables.computeIfAbsent(varName, key -> {
            throw new HigsonRuntimeException("Action outputVariable " + varName + " not found in flow variables");
        });
    }

    private Object getArg(String name) {
        return this.arguments.computeIfAbsent(name, key -> {
            throw new HigsonRuntimeException("Action argument " + name + " not found in flow variables");
        });
    }

    private String pad(String text, int width) {
        return StringUtils.rightPad((String)text, (int)width);
    }

    private ParamContext overrideCtx(HigsonContext ctx, List<ActionArgument> arguments) {
        if (CollectionUtils.isEmpty(arguments)) {
            return ctx;
        }
        AdhocContext adhocContext = new AdhocContext(ctx);
        arguments.forEach(arg -> adhocContext.with(arg.getName(), this.getArgumentValue((ActionArgument)arg)));
        return adhocContext;
    }

    private List<Variable> getVarSnapshot() {
        return this.variables.values().stream().map(Variable::copy).collect(Collectors.toList());
    }

    private static class DomainMeta {
        private final String profile;
        private final String path;
        private final String attribute;

        DomainMeta(String domainMeta) {
            String[] domain = StringUtils.split((String)domainMeta, (char)':');
            if (domain.length != 3) {
                throw new HigsonRuntimeException("Incorrect domain type action value " + domainMeta + " - expected format profile:path:attribute");
            }
            this.profile = domain[0].trim();
            this.path = domain[1].trim();
            this.attribute = domain[2].trim();
        }

        public String getProfile() {
            return this.profile;
        }

        public String getPath() {
            return this.path;
        }

        public String getAttribute() {
            return this.attribute;
        }
    }
}

