/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow;

import io.higson.runtime.helper.TypeConverter;

public class Variable {
    public static final String OBJECT_TYPE = "object";
    private final String name;
    private Object value;
    private String type;
    private boolean returned;

    public void setValue(Object value) {
        this.value = this.isObjectType() ? value : TypeConverter.getInstance().cast(value, this.type);
    }

    private boolean isObjectType() {
        return OBJECT_TYPE.equals(this.type);
    }

    public Variable copy() {
        return new Variable(this.name, this.value, this.type, this.returned);
    }

    public String print() {
        return this.name + "=" + this.value;
    }

    public static VariableBuilder builder() {
        return new VariableBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReturned() {
        return this.returned;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setReturned(boolean returned) {
        this.returned = returned;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReturned() != other.isReturned()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Variable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReturned() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "Variable(name=" + this.getName() + ", value=" + this.getValue() + ", type=" + this.getType() + ", returned=" + this.isReturned() + ")";
    }

    public Variable(String name, Object value, String type, boolean returned) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.returned = returned;
    }

    public static class VariableBuilder {
        private String name;
        private Object value;
        private String type;
        private boolean returned;

        VariableBuilder() {
        }

        public VariableBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VariableBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public VariableBuilder type(String type) {
            this.type = type;
            return this;
        }

        public VariableBuilder returned(boolean returned) {
            this.returned = returned;
            return this;
        }

        public Variable build() {
            return new Variable(this.name, this.value, this.type, this.returned);
        }

        public String toString() {
            return "Variable.VariableBuilder(name=" + this.name + ", value=" + this.value + ", type=" + this.type + ", returned=" + this.returned + ")";
        }
    }
}

