/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.higson.runtime.flow.dto.FlowDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowDtoConverter {
    private static final Logger log = LoggerFactory.getLogger(FlowDtoConverter.class);
    private static final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();

    private FlowDtoConverter() {
    }

    public static String convertToString(FlowDto flowDto) {
        try {
            return flowDto != null ? mapper.writeValueAsString((Object)flowDto) : null;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static FlowDto convertToDto(String body) {
        if (StringUtils.isEmpty((CharSequence)body)) {
            return FlowDto.EMPTY;
        }
        try {
            FlowDto flowDto = (FlowDto)mapper.readValue(body, FlowDto.class);
            return flowDto != null ? flowDto : FlowDto.EMPTY;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

