/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow.dto;

import io.higson.runtime.flow.Action;
import io.higson.runtime.flow.ActionArgument;
import io.higson.runtime.flow.Condition;
import io.higson.runtime.flow.Flow;
import io.higson.runtime.flow.Link;
import io.higson.runtime.flow.Node;
import io.higson.runtime.flow.Variable;
import io.higson.runtime.flow.dto.ActionArgumentDto;
import io.higson.runtime.flow.dto.ActionDto;
import io.higson.runtime.flow.dto.ArgumentDto;
import io.higson.runtime.flow.dto.ConditionDto;
import io.higson.runtime.flow.dto.FlowDto;
import io.higson.runtime.flow.dto.FlowDtoConverter;
import io.higson.runtime.flow.dto.LinkDto;
import io.higson.runtime.flow.dto.NodeDto;
import io.higson.runtime.flow.dto.VariableDto;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class FlowRuntimeConverter {
    public static Flow convert(String flowString) {
        FlowDto flowDto = FlowDtoConverter.convertToDto(flowString);
        return FlowRuntimeConverter.convert(flowDto);
    }

    public static Flow convert(FlowDto flowDto) {
        return Flow.builder().arguments(FlowRuntimeConverter.mapArguments(flowDto.getArguments())).variables(FlowRuntimeConverter.mapVariables(flowDto.getVariables())).nodes(FlowRuntimeConverter.mapNodes(flowDto.getNodes())).startNodeId(flowDto.getStartNodeId()).build();
    }

    private static List<String> mapArguments(List<ArgumentDto> arguments) {
        return arguments.stream().map(ArgumentDto::getName).collect(Collectors.toList());
    }

    private static List<Node> mapNodes(List<NodeDto> nodes) {
        return nodes.stream().map(n -> Node.builder().id(n.getId()).defaultNextNode(n.getDefaultNextNode()).links(FlowRuntimeConverter.mapLinks(n.getLinks())).actions(FlowRuntimeConverter.mapActions(n.getActions())).build()).toList();
    }

    private static List<Action> mapActions(List<ActionDto> actions) {
        return actions.stream().map(action -> Action.builder().value(action.getValue()).outputVariable(action.getOutputVariable()).type(action.getType()).arguments(FlowRuntimeConverter.mapActionArguments(action.getArguments())).build()).toList();
    }

    private static List<ActionArgument> mapActionArguments(List<ActionArgumentDto> arguments) {
        return arguments.stream().map(argument -> ActionArgument.builder().value(argument.getValue()).sourceType(argument.getSource()).name(argument.getName()).build()).toList();
    }

    private static List<Link> mapLinks(List<LinkDto> links) {
        return links.stream().map(link -> Link.builder().conditionString(link.getConditionString()).condition(FlowRuntimeConverter.mapCondition(link.getCondition())).target(link.getTarget()).build()).toList();
    }

    private static List<Condition> mapCondition(List<ConditionDto> condition) {
        if (condition == null) {
            return Collections.emptyList();
        }
        return condition.stream().map(c -> Condition.builder().leftInputType(c.getLeftInputType()).leftInputValue(c.getLeftInputValue()).operator(c.getOperator()).rightInputType(c.getRightInputType()).rightInputValue(c.getRightInputValue()).joinConditionOperator(c.getJoinConditionOperator()).build()).toList();
    }

    private static List<Variable> mapVariables(List<VariableDto> variables) {
        return variables.stream().map(v -> Variable.builder().name(v.getName()).type(v.getType()).value(v.getValue()).returned(v.isReturned()).build()).toList();
    }

    private FlowRuntimeConverter() {
    }
}

