/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow.trace;

import io.higson.runtime.flow.Variable;
import io.higson.runtime.flow.trace.Event;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FlowTrace {
    private List<Event> events = new ArrayList<Event>();

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public void addEvents(List<Event> events) {
        this.events.addAll(events);
    }

    public String print(boolean verbose) {
        long base = this.events.get(0).getCreated();
        StringBuilder sb = new StringBuilder();
        sb.append("-".repeat(15)).append(" flow trace ").append("-".repeat(15)).append("\n\n");
        int ix = 0;
        for (Event event : this.events) {
            sb.append(String.format("%2d : %5d : %s \n", ++ix, this.elapsedMillis(event.getCreated() - base), event.print()));
            if (!verbose) continue;
            for (Variable var : event.getVariables()) {
                if (var.getValue() == null) continue;
                sb.append(String.format("                %s \n", this.print(var)));
            }
        }
        return sb.toString();
    }

    String print(Variable var) {
        return StringUtils.rightPad((String)var.getName(), (int)16) + " = " + var.getValue();
    }

    private long elapsedMillis(long time) {
        return time / 1000000L;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public List<Event> getEvents() {
        return this.events;
    }
}

