/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.function;

import java.util.Set;

public enum FunctionType {
    RHINO,
    GROOVY,
    PYTHON,
    FLOW;

    private final String code = this.name().toLowerCase();

    public String code() {
        return this.code;
    }

    public boolean isEqualTo(String code) {
        return this.code.equalsIgnoreCase(code);
    }

    public String toString() {
        return this.code();
    }

    public static FunctionType of(String type) {
        for (FunctionType funType : FunctionType.values()) {
            if (!funType.toString().equalsIgnoreCase(type)) continue;
            return funType;
        }
        throw new IllegalArgumentException("Illegal argument for FunctionType: " + type);
    }

    public static Set<String> standardFunctions() {
        return Set.of(FunctionType.RHINO.code, FunctionType.GROOVY.code, FunctionType.PYTHON.code);
    }
}

