/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.invoker;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.engine.core.function.Function;
import io.higson.runtime.engine.core.function.FunctionInvoker;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.flow.FlowExecutor;
import io.higson.runtime.flow.FlowPrefix;
import io.higson.runtime.flow.FlowResult;
import io.higson.runtime.invoker.GroovyFunctionInvoker;
import io.higson.runtime.model.FlowFunction;
import io.higson.runtime.profiler.engine.EngineProfiler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(FlowInvoker.class);
    private static final EngineProfiler profiler = EngineProfiler.FUNCTION;
    private static final FlowResult EMPTY_RESULT = new FlowResult();
    private HigsonEngine higsonEngine;
    private final GroovyFunctionInvoker groovyFunctionInvoker;

    public FlowInvoker(GroovyFunctionInvoker groovyFunctionInvoker) {
        this.groovyFunctionInvoker = groovyFunctionInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Function function, Object ... args) {
        long t = System.currentTimeMillis();
        try {
            FlowFunction flowFunction = this.cast(function);
            if (StringUtils.isEmpty((CharSequence)flowFunction.getBody())) {
                log.warn("Empty flow body {}", (Object)FlowPrefix.withoutPrefix(function.getName()));
                FlowResult flowResult = EMPTY_RESULT;
                return flowResult;
            }
            FlowResult flowResult = this.getFlowExecutor(flowFunction, args).execute();
            return flowResult;
        }
        finally {
            profiler.addGetMeasure(function.getName(), t, System.currentTimeMillis());
        }
    }

    private FlowExecutor getFlowExecutor(FlowFunction flowFunction, Object[] args) {
        return new FlowExecutor(this.higsonEngine, this.groovyFunctionInvoker, flowFunction.getFlow(), flowFunction.getName(), args);
    }

    private FlowFunction cast(Function function) {
        if (function instanceof FlowFunction) {
            return (FlowFunction)function;
        }
        log.error("Unexpected flow: {}", (Object)function);
        throw new HigsonRuntimeException("Illegal function passed to FlowInvoker: " + function);
    }

    public void setHigsonEngine(HigsonEngine higsonEngine) {
        this.higsonEngine = higsonEngine;
    }
}

