/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model.region;

import io.higson.runtime.model.region.RegionIdentifier;
import org.apache.commons.lang3.StringUtils;

public final class RegionVersionIdentifier {
    private final RegionIdentifier regionIdentifier;
    private final String version;
    private String description;
    private boolean overrideDescription = false;

    public RegionVersionIdentifier(String profileCode, String regionCode, String version) {
        this(new RegionIdentifier(profileCode, regionCode), version);
    }

    public RegionVersionIdentifier(RegionIdentifier regionIdentifier, String version) {
        this.regionIdentifier = regionIdentifier;
        this.version = version;
    }

    public void shouldOverrideDescription(String description) {
        this.description = description;
        this.overrideDescription = true;
    }

    public String getDescription() {
        return StringUtils.trimToNull((String)this.description);
    }

    public String getProfileCode() {
        return this.regionIdentifier.getProfileCode();
    }

    public String getRegionCode() {
        return this.regionIdentifier.getRegionCode();
    }

    public String toString() {
        return this.regionIdentifier + "@" + this.version;
    }

    public RegionIdentifier getRegionIdentifier() {
        return this.regionIdentifier;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isOverrideDescription() {
        return this.overrideDescription;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionVersionIdentifier)) {
            return false;
        }
        RegionVersionIdentifier other = (RegionVersionIdentifier)o;
        if (this.isOverrideDescription() != other.isOverrideDescription()) {
            return false;
        }
        RegionIdentifier this$regionIdentifier = this.getRegionIdentifier();
        RegionIdentifier other$regionIdentifier = other.getRegionIdentifier();
        if (this$regionIdentifier == null ? other$regionIdentifier != null : !((Object)this$regionIdentifier).equals(other$regionIdentifier)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOverrideDescription() ? 79 : 97);
        RegionIdentifier $regionIdentifier = this.getRegionIdentifier();
        result = result * 59 + ($regionIdentifier == null ? 43 : ((Object)$regionIdentifier).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

