/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler.jdbc.proxy;

import io.higson.runtime.profiler.jdbc.JdbcProfiler;
import io.higson.runtime.profiler.jdbc.proxy.ProxyExceptionHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(PreparedStatementProxy.class);
    private static final Class<?>[] INTERFACES = new Class[]{PreparedStatement.class};
    private final PreparedStatement ps;
    private final String sql;

    private PreparedStatementProxy(String sql, PreparedStatement ps) {
        this.sql = sql;
        this.ps = ps;
    }

    public static PreparedStatement newInstance(String sql, PreparedStatement ps) {
        return (PreparedStatement)Proxy.newProxyInstance(ps.getClass().getClassLoader(), INTERFACES, (InvocationHandler)new PreparedStatementProxy(sql, ps));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean profile = method.getName().startsWith("execute");
        long t = profile ? System.currentTimeMillis() : 0L;
        try {
            Object object = method.invoke((Object)this.ps, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw ProxyExceptionHandler.handleException(e, this.sql);
        }
        finally {
            if (profile) {
                this.onExecute(t, System.currentTimeMillis());
            }
        }
    }

    private void onExecute(long t1, long t2) {
        JdbcProfiler.getSingleton().sqlExecuted(this.sql, t2 - t1);
    }
}

