/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler.jdbc.proxy;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ProxyExceptionHandler.class);

    static Throwable handleException(InvocationTargetException e, Object[] args) {
        log.error("failed to execute statement: {}", (Object)Arrays.toString(args));
        return ProxyExceptionHandler.unwrap(e);
    }

    static Throwable handleException(InvocationTargetException e, String sql) {
        log.error("failed to execute prepared statement: {}", (Object)sql);
        return ProxyExceptionHandler.unwrap(e);
    }

    static Throwable handleException(InvocationTargetException e) {
        return ProxyExceptionHandler.unwrap(e);
    }

    static Throwable unwrap(InvocationTargetException e) {
        return e.getCause() != null ? e.getCause() : e;
    }
}

