/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider.ai;

import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.model.MpParameterEntry;
import io.higson.runtime.provider.ai.AiModelExecutionException;
import io.higson.runtime.provider.ai.AiModelInputConverter;
import io.higson.runtime.provider.ai.AiModelOutputConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AiModelExecutor {
    private final OrtEnvironment env;
    private final AiModelInputConverter inputConverter = new AiModelInputConverter();
    private final AiModelOutputConverter outputConverter = new AiModelOutputConverter();

    public List<ParameterEntry> execute(OrtSession session, String[][] inputLevels) throws AiModelExecutionException {
        try {
            float[][] inputData = this.inputConverter.convert(inputLevels);
            Map<String, OnnxTensor> inputs = this.prepareInputs(session, inputData);
            OrtSession.Result outputs = session.run(inputs);
            Optional result = outputs.get(this.findOutputName(session));
            OnnxTensor predictionsTensor = (OnnxTensor)result.orElseThrow(AiModelExecutionException::noResult);
            float[][] predictions = (float[][])predictionsTensor.getValue();
            inputs.values().forEach(OnnxTensor::close);
            outputs.close();
            return this.outputConverter.convert(inputData, predictions).stream().map(MpParameterEntry::new).map(ParameterEntry.class::cast).toList();
        }
        catch (OrtException e) {
            throw AiModelExecutionException.executionError(e);
        }
    }

    private Map<String, OnnxTensor> prepareInputs(OrtSession session, float[][] inputData) throws OrtException, AiModelExecutionException {
        OnnxTensor inputTensor = OnnxTensor.createTensor((OrtEnvironment)this.env, (Object)inputData);
        HashMap<String, OnnxTensor> inputs = new HashMap<String, OnnxTensor>();
        String inputName = this.findInputName(session);
        inputs.put(inputName, inputTensor);
        return inputs;
    }

    private String findInputName(OrtSession session) throws AiModelExecutionException {
        return (String)session.getInputNames().stream().findFirst().orElseThrow(AiModelExecutionException::inputNotFound);
    }

    private String findOutputName(OrtSession session) throws AiModelExecutionException {
        return (String)session.getOutputNames().stream().findFirst().orElseThrow(AiModelExecutionException::outputNotFound);
    }

    public AiModelExecutor(OrtEnvironment env) {
        this.env = env;
    }
}

