/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider.ai;

import io.higson.runtime.provider.ai.AiModelInvalidInputException;

class AiModelInputConverter {
    AiModelInputConverter() {
    }

    public float[][] convert(String[][] inputLevels) {
        if (inputLevels == null) {
            return null;
        }
        if (this.isInputLevelsEmpty(inputLevels)) {
            return new float[0][0];
        }
        try {
            return this.translateRowsToColumns(inputLevels);
        }
        catch (NumberFormatException e) {
            throw new AiModelInvalidInputException(e);
        }
    }

    private float[][] translateRowsToColumns(String[][] inputLevels) {
        float[][] inputData = new float[inputLevels[0].length][];
        for (int i = 0; i < inputLevels[0].length; ++i) {
            float[] rows = new float[inputLevels.length];
            for (int j = 0; j < inputLevels.length; ++j) {
                rows[j] = Float.parseFloat(inputLevels[j][i]);
            }
            inputData[i] = rows;
        }
        return inputData;
    }

    private boolean isInputLevelsEmpty(String[][] inputLevels) {
        return inputLevels.length == 0 || inputLevels[0].length == 0;
    }
}

