/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider.ai;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

class AiModelOutputConverter {
    AiModelOutputConverter() {
    }

    public List<String[]> convert(float[][] inputData, float[][] predictions) {
        if (inputData == null || predictions == null) {
            return null;
        }
        if (AiModelOutputConverter.isInputDataEmpty(inputData) || AiModelOutputConverter.isPredictionsEmpty(predictions)) {
            return List.of();
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int i = 0; i < inputData.length; ++i) {
            float[] combinedInputsAndOutputs = ArrayUtils.addAll((float[])inputData[i], (float[])predictions[i]);
            result.add(this.toStringArray(combinedInputsAndOutputs));
        }
        return result;
    }

    private static boolean isInputDataEmpty(float[][] inputData) {
        return inputData.length == 0 || inputData[0].length == 0;
    }

    private static boolean isPredictionsEmpty(float[][] predictions) {
        return predictions.length == 0 || predictions[0].length == 0;
    }

    private String[] toStringArray(float[] floats) {
        String[] strings = new String[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            strings[i] = String.valueOf(floats[i]);
        }
        return strings;
    }
}

