/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider.ai;

import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.provider.ai.AiModelExecutionException;
import io.higson.runtime.provider.ai.AiModelExecutor;
import io.higson.runtime.provider.ai.ParameterAiModelExecutionException;
import io.higson.runtime.provider.ai.ParameterAiModelLoadingException;
import io.higson.runtime.provider.ai.ParameterAiModelService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterAiModelServiceImpl
implements ParameterAiModelService {
    private static final Logger log = LoggerFactory.getLogger(ParameterAiModelServiceImpl.class);
    private final OrtEnvironment env;
    private final AiModelExecutor executor;

    @Override
    public List<ParameterEntry> executeAiModel(Parameter parameter, String[][] inputLevels) {
        try {
            return this.executor.execute(parameter.getAiSourceSession(), inputLevels);
        }
        catch (AiModelExecutionException e) {
            throw new ParameterAiModelExecutionException(parameter.getName(), e);
        }
    }

    @Override
    public Parameter loadAiModel(Parameter parameter) {
        try {
            OrtSession session = this.env.createSession(parameter.getAiModel());
            parameter.setAiSourceSession(session);
            return parameter;
        }
        catch (OrtException e) {
            throw new ParameterAiModelLoadingException(parameter.getName(), e);
        }
    }

    public ParameterAiModelServiceImpl(OrtEnvironment env, AiModelExecutor executor) {
        this.env = env;
        this.executor = executor;
    }
}

