/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.rhino;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.engine.annotated.annotations.FetchSuggestion;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.model.DomainObject;
import io.higson.runtime.rhino.domain.RhinoDomainElement;
import java.util.List;

public class RhinoDomain {
    private final HigsonEngine engine;

    public RhinoDomain(HigsonEngine engine) {
        this.engine = engine;
    }

    @FetchSuggestion(value="suggester.domain.get_profile_path_ctx")
    public RhinoDomainElement get(String profile, String path, HigsonContext ctx) {
        DomainObject obj = this.engine.getDomain(profile, path);
        if (obj == null) {
            throw new HigsonRuntimeException(String.format("Unknown path or profile: profile=[%s] path=[%s]", profile, path));
        }
        return new RhinoDomainElement(obj, ctx);
    }

    @FetchSuggestion(value="suggester.domain.get_profile_path")
    public RhinoDomainElement get(String profile, String path) {
        return this.get(profile, path, null);
    }

    @FetchSuggestion(value="suggester.domain.get_profile_ctx")
    public RhinoDomainElement get(String profile, HigsonContext ctx) {
        return this.get(profile, null, ctx);
    }

    @FetchSuggestion(value="suggester.domain.get_profile")
    public RhinoDomainElement get(String profile) {
        return this.get(profile, null, null);
    }

    @FetchSuggestion(value="suggester.domain.getProfiles")
    public List<String> getProfiles() {
        return this.engine.getProfiles();
    }
}

