/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.rhino.helper;

import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.output.ParamValueImpl;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.rhino.helper.MultiValueBuilder;
import io.higson.runtime.rhino.value.RhinoParamValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ParamValueBuilder {
    private String[] codes;
    private String[] types;
    private final List<MultiValue> rows = new ArrayList<MultiValue>(2);

    public ParamValueBuilder withCodes(String ... codes) {
        this.codes = codes;
        return this;
    }

    public ParamValueBuilder withCodes(Object obj) {
        return this.withCodes(this.toArray(obj));
    }

    public ParamValueBuilder withTypes(String ... types) {
        this.types = types;
        return this;
    }

    public ParamValueBuilder withTypes(Object obj) {
        return this.withTypes(this.toArray(obj));
    }

    public ParamValueBuilder withMatrix(Object[][] matrix) {
        this.rows.clear();
        this.assertDataProvided();
        for (Object[] row : matrix) {
            this.rows.add(this.toMultiValue(row));
        }
        return this;
    }

    public ParamValueBuilder addValues(Object ... values) {
        this.assertDataProvided();
        int colCnt = this.codes.length;
        if (values.length % colCnt != 0) {
            throw new HigsonRuntimeException(String.format("Provided incomplete matrix - number of cells: %d, number of columns: %d", values.length, colCnt));
        }
        for (int i = 0; i < values.length; i += colCnt) {
            Object[] row = Arrays.copyOfRange(values, i, i + colCnt);
            this.rows.add(this.toMultiValue(row));
        }
        return this;
    }

    public ParamValueBuilder addValues(Collection coll) {
        return this.addValues(coll.toArray());
    }

    public ParamValueBuilder withValues(Object ... values) {
        this.rows.clear();
        this.addValues(values);
        return this;
    }

    public ParamValueBuilder withValues(Collection coll) {
        return this.withValues(coll.toArray());
    }

    private MultiValue toMultiValue(Object[] row) {
        return new MultiValueBuilder().withCodes(this.codes).withTypes(this.types).withValues(row).build();
    }

    private void assertDataProvided() {
        if (this.types == null || this.codes == null || this.types.length != this.codes.length) {
            throw new HigsonRuntimeException("Illegal usage of ParamValueBuilder - you have to provide codes and types for all columns");
        }
    }

    public ParamValue build() {
        MultiValue[] array = this.rows.toArray(new MultiValue[this.rows.size()]);
        return new ParamValueImpl(array);
    }

    public RhinoParamValue create() {
        return new RhinoParamValue(this.build());
    }

    private String[] toArray(Object obj) {
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String) {
            return new String[]{obj.toString()};
        }
        ArrayList<String> result = new ArrayList<String>(2);
        if (obj instanceof Object[]) {
            for (Object e : (Object[])obj) {
                result.add(String.valueOf(e));
            }
        } else if (obj instanceof Iterable) {
            for (Object e : (Iterable)obj) {
                result.add(String.valueOf(e));
            }
        } else {
            String msg = obj != null ? obj.getClass().getName() : "[null]";
            throw new HigsonRuntimeException("Expected string array/collection but found: " + msg);
        }
        return result.toArray(new String[result.size()]);
    }
}

