/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sorter;

import io.higson.runtime.sorter.SortColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SortConfig {
    private final List<SortColumn> columns;

    public SortConfig(SortColumn ... cols) {
        this.columns = new ArrayList<SortColumn>(Arrays.asList(cols));
    }

    public SortConfig(List<SortColumn> cols) {
        this.columns = cols;
    }

    public List<SortColumn> getColumns() {
        return this.columns;
    }

    public SortColumn get(int i) {
        return this.columns.get(i);
    }

    public String toString() {
        return String.valueOf(this.columns);
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SortColumn col = this.columns.get(i);
            sb.append(col.getName());
            sb.append(' ').append(col.getOrder().toString().toLowerCase());
            if (col.isText()) {
                sb.append(" text");
            }
            if (col.getLocale() != null) {
                sb.append(' ').append(col.getLocale().getLanguage());
            }
            if (col.isIgnoreCase()) continue;
            sb.append(" sensitive");
        }
        return sb.toString();
    }
}

