/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.cache.UserRegionVersionCache;
import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.UserRegionVersion;
import io.higson.runtime.sync.BaseWatcher;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UserRegionVersionRuntimeWatcher
extends BaseWatcher {
    private final VersionDao versionJdbcDao;
    private final UserRegionVersionCache userRegionVersionCache;
    private Date lastRunDate;

    @Override
    protected String getWatcherName() {
        return "userRegionVersion-runtime-watcher";
    }

    @Override
    public void doWatch() {
        List<UserRegionVersion> currentUserRegionVersions = this.versionJdbcDao.getAllUserRegionVersions();
        Synchronizer synchronizer = new Synchronizer(currentUserRegionVersions);
        synchronizer.synchronize();
        this.lastRunDate = new Date();
    }

    public UserRegionVersionRuntimeWatcher(VersionDao versionJdbcDao, UserRegionVersionCache userRegionVersionCache) {
        this.versionJdbcDao = versionJdbcDao;
        this.userRegionVersionCache = userRegionVersionCache;
    }

    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    private class Synchronizer {
        private final Map<UserRegionVersionCache.CacheKey, Set<RegionVersion>> currentUserRegionVersions = new HashMap<UserRegionVersionCache.CacheKey, Set<RegionVersion>>();

        private Synchronizer(List<UserRegionVersion> currentUserRegionVersions) {
            for (UserRegionVersion v : currentUserRegionVersions) {
                UserRegionVersionCache.CacheKey cacheKey = new UserRegionVersionCache.CacheKey(v.getProfileCode(), v.getUserName());
                Set versionSet = this.currentUserRegionVersions.computeIfAbsent(cacheKey, k -> new HashSet());
                versionSet.add(v.getRegionVersion());
            }
        }

        private void synchronize() {
            Set<UserRegionVersionCache.CacheKey> keys = UserRegionVersionRuntimeWatcher.this.userRegionVersionCache.getAllKeys();
            keys.forEach(this::synchronize);
        }

        private void synchronize(UserRegionVersionCache.CacheKey key) {
            UserRegionVersionRuntimeWatcher.this.log.debug("Synchronizing cache for key: {}", (Object)key);
            String user = key.getUser();
            String profileCode = key.getProfileCode();
            Set<RegionVersion> currentUserRegionVersions = this.currentUserRegionVersions.get(new UserRegionVersionCache.CacheKey(profileCode, user));
            Set<RegionVersion> cachedUserRegionVersions = UserRegionVersionRuntimeWatcher.this.userRegionVersionCache.get(profileCode, user);
            if (!Objects.equals(currentUserRegionVersions, cachedUserRegionVersions)) {
                UserRegionVersionRuntimeWatcher.this.log.debug("Cache entry for profileCode: {} and user {} is stale. Invalidating.", (Object)profileCode, (Object)user);
                UserRegionVersionRuntimeWatcher.this.userRegionVersionCache.invalidate(profileCode, user);
                if (currentUserRegionVersions != null) {
                    UserRegionVersionRuntimeWatcher.this.userRegionVersionCache.put(profileCode, user, currentUserRegionVersions);
                }
            }
        }
    }
}

