/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smartparam.engine.core.prepared.CacheEntry;

public class MapCache<T> {
    protected final Map<String, T> cache = new ConcurrentHashMap<String, T>();

    public void put(String key, T object) {
        this.cache.put(key, object);
    }

    public void putAll(Map<String, T> otherMap) {
        this.cache.putAll(otherMap);
    }

    public T get(String key) {
        return this.cache.get(key);
    }

    public void invalidate(String key) {
        this.cache.remove(key);
    }

    public void invalidate() {
        this.cache.clear();
    }

    public List<CacheEntry<T>> list() {
        ArrayList<CacheEntry<T>> snapshot = new ArrayList<CacheEntry<T>>(this.cache.size());
        for (Map.Entry<String, T> e : this.cache.entrySet()) {
            snapshot.add(new CacheEntry<T>(e.getKey(), e.getValue()));
        }
        return snapshot;
    }
}

