/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.context;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.smartparam.engine.annotated.annotations.CtxPathParam;
import org.smartparam.engine.annotated.annotations.FetchSuggestion;
import org.smartparam.engine.core.context.ContextInitializationException;
import org.smartparam.engine.core.context.DuplicateContextItemException;
import org.smartparam.engine.core.context.InvalidContextArgumentsCountException;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.util.reflection.InnerReflectiveOperationException;
import org.smartparam.engine.util.reflection.ReflectionSetterInvoker;
import pl.decerto.hyperon.runtime.helper.AsciiUtil;

public class DefaultContext
implements ParamContext {
    private static final String SUGGESTER_DEPRECATED = "suggester.deprecated";
    private static ReflectionSetterInvoker sharedSetterInvoker = new ReflectionSetterInvoker();
    private ReflectionSetterInvoker setterInvoker = sharedSetterInvoker;
    private Map<String, Object> userContext;
    private Object[][] levelValues;

    public DefaultContext(Object ... args) {
        this.initialize(args);
    }

    public DefaultContext() {
    }

    protected final void initialize(Object ... args) {
        for (int argumentIndex = 0; argumentIndex < args.length; ++argumentIndex) {
            boolean setterFound;
            Object arg = this.getArgumentAt(args, argumentIndex);
            if (argumentIndex == 0 && arg instanceof ReflectionSetterInvoker) {
                this.setterInvoker = (ReflectionSetterInvoker)arg;
                continue;
            }
            if (arg instanceof String[]) {
                this.setLevelValues((Object[])arg);
                continue;
            }
            if (arg instanceof Object[]) {
                this.setLevelValues((Object[])arg);
                continue;
            }
            if (arg instanceof String) {
                this.with((String)arg, this.getArgumentAt(args, ++argumentIndex));
                continue;
            }
            if (arg == null || (setterFound = this.findAndInvokeSetter(arg))) continue;
            this.set(arg);
        }
    }

    @FetchSuggestion(value="suggester.ctx.with_str_obj")
    public final DefaultContext with(@CtxPathParam String key, Object value) {
        return this.with(key, value, false);
    }

    @FetchSuggestion(value="suggester.ctx.with_str_obj_boolean")
    public final DefaultContext with(@CtxPathParam String key, Object value, boolean allowOverwrite) {
        String modifiedKey;
        if (this.userContext == null) {
            this.userContext = new TreeMap<String, Object>();
        }
        if (this.userContext.containsKey(modifiedKey = this.modifyKey(key)) && !allowOverwrite) {
            throw new DuplicateContextItemException(key);
        }
        this.userContext.put(modifiedKey, value);
        return this;
    }

    protected String modifyKey(String key) {
        return AsciiUtil.lowercase(key);
    }

    @FetchSuggestion(value="suggester.deprecated")
    public final DefaultContext set(Object value) {
        return this.with(value.getClass().getSimpleName(), value);
    }

    public Object get(@CtxPathParam(unrecommended={CtxPathParam.CtxAttrType.VALUE}) String key) {
        return this.userContext != null ? this.userContext.get(this.modifyKey(key)) : null;
    }

    protected DefaultContext adhoc(DefaultContext ctx) {
        this.userContext = ctx.userContext;
        return this;
    }

    @FetchSuggestion(value="suggester.deprecated")
    public <T> T get(@CtxPathParam(unrecommended={CtxPathParam.CtxAttrType.VALUE}) String key, Class<T> targetClass) {
        return (T)this.get(key);
    }

    public String getString(@CtxPathParam(allowed={CtxPathParam.CtxAttrType.VALUE}) String key) {
        return this.get(key, String.class);
    }

    @FetchSuggestion(value="suggester.ctx.get_class")
    public <T> T get(Class<T> clazz) {
        if (this.userContext != null) {
            Object obj = this.get(clazz.getSimpleName());
            if (obj != null && obj.getClass() == clazz) {
                return (T)obj;
            }
            for (Object contextValue : this.userContext.values()) {
                if (contextValue == null || !clazz.isAssignableFrom(contextValue.getClass())) continue;
                return (T)contextValue;
            }
        }
        return null;
    }

    private Object getArgumentAt(Object[] args, int index) {
        if (index < args.length) {
            return args[index];
        }
        throw new InvalidContextArgumentsCountException(index, args.length);
    }

    private boolean findAndInvokeSetter(Object arg) {
        try {
            return this.setterInvoker.invokeSetter(this, arg);
        }
        catch (InnerReflectiveOperationException exception) {
            throw new ContextInitializationException(exception, arg);
        }
    }

    @Override
    @FetchSuggestion(value="suggester.deprecated")
    public Object[][] getLevelValues() {
        return this.levelValues;
    }

    @Override
    @FetchSuggestion(value="suggester.deprecated")
    public final void setLevelValues(Object ... levelValues) {
        if (levelValues != null) {
            this.levelValues = new Object[levelValues.length][];
            for (int i = 0; i < levelValues.length; ++i) {
                this.levelValues[i] = levelValues[i] instanceof Object[] ? (Object[])levelValues[i] : new Object[]{levelValues[i]};
            }
        } else {
            this.levelValues = null;
        }
    }

    @FetchSuggestion(value="suggester.deprecated")
    public DefaultContext withLevelValues(String ... levelValues) {
        this.setLevelValues(levelValues);
        return this;
    }

    @FetchSuggestion(value="suggester.deprecated")
    public DefaultContext withLevelValues(Object ... levelValues) {
        this.setLevelValues(levelValues);
        return this;
    }

    protected Map<String, Object> getUserContext() {
        return this.userContext;
    }

    public String toString() {
        return "DefaultContext[levelValues=" + Arrays.toString((Object[])this.levelValues) + ", userContext=" + this.userContext + "]";
    }
}

