/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.extdatasource;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class ExternalDataSourceProvider {
    private final Map<String, DataSource> externalDataSourceMap = new LinkedHashMap<String, DataSource>();

    public ExternalDataSourceProvider withExternalDataSource(String code, DataSource dataSource) {
        this.externalDataSourceMap.put(code, dataSource);
        return this;
    }

    public DataSource getDataSource(String code) {
        if (code != null) {
            return this.externalDataSourceMap.get(code);
        }
        throw new HyperonRuntimeException("DataSource code not provided");
    }

    public boolean hasExternalDataSources() {
        return !this.externalDataSourceMap.isEmpty();
    }

    public Collection<String> listExternalDataSources() {
        return this.externalDataSourceMap.keySet();
    }
}

