/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sql.dialect;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DatabaseDialect {
    H2("h2"),
    ORACLE("oracle"),
    HSQLAB("hsqldb"),
    MSSQL2012("mssql2012"),
    POSTGRESQL("postgresql"),
    MYSQL("mysql");

    private String dialect;

    public static Set<String> getDialects() {
        return Stream.of(DatabaseDialect.values()).map(DatabaseDialect::getDialect).collect(Collectors.toSet());
    }

    public static boolean supports(String dialect) {
        return DatabaseDialect.getDialects().stream().anyMatch(dialect::equals);
    }

    private DatabaseDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getDialect() {
        return this.dialect;
    }
}

