/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

class TraceSupplier<T>
implements Supplier<T> {
    private final Tracer tracer;
    private final Supplier<T> delegate;
    private final AtomicReference<Span> span;

    TraceSupplier(Tracer tracer, Supplier<T> delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.span = new AtomicReference<Span>(this.tracer.nextSpan());
    }

    @Override
    public T get() {
        String name = this.delegate.getClass().getSimpleName();
        Span span = this.span.get().name(name);
        Throwable tr = null;
        try {
            T t;
            block12: {
                Tracer.SpanInScope ws = this.tracer.withSpan(span.start());
                try {
                    t = this.delegate.get();
                    if (ws == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        tr = t2;
                        throw t2;
                    }
                }
                ws.close();
            }
            return t;
        }
        finally {
            if (tr != null) {
                span.error(tr);
            }
            span.end();
            this.span.set(null);
        }
    }
}

